// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TEVENT_HH
#define __TEVENT_HH

#include "TGlobals.hh"
#include "TDataRecord.hh"

class TDataRecord;

class TEvent
{

  private:
    Tint theEventNumber;
    TDataRecord theDataRecord;

  public:
    TEvent( Tint eventID, const TDataRecord& eventData );
    TEvent( const TEvent& right );
    ~TEvent();

  public:
    const TEvent& operator=( const TEvent& right );
    Tbool operator==( const TEvent& right ) const;
    Tbool operator!=( const TEvent& right ) const;

  public:
    Tint GetEventNumber() const;
    const TDataRecord& GetDataRecord() const;
    Tvoid SetEventNumber( Tint eventID );
    Tvoid SetDataRecord( const TDataRecord& eventData );

};

inline Tint TEvent::GetEventNumber() const
{
  return( theEventNumber );
}

inline const TDataRecord& TEvent::GetDataRecord() const
{
  return( theDataRecord );
}

inline Tvoid TEvent::SetEventNumber( Tint eventID )
{
  theEventNumber = eventID;
  return;
}

inline Tvoid TEvent::SetDataRecord( const TDataRecord& eventData )
{
  theDataRecord = eventData;
  return;
}

#endif
