// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TReadoutSegment.hh"
#include "TDataSegment.hh"
#include "TModule.hh"

TReadoutSegment::TReadoutSegment( Tint id )
  : TReadoutElementList(), theID( id ), theModule( 0 )
{;}

TReadoutSegment::TReadoutSegment( TModule* module, Tint id )
  : TReadoutElementList(), theID( id ), theModule( module )
{;}

TReadoutSegment::TReadoutSegment( const TReadoutSegment& right )
  : TReadoutElementList( right ), theID( right.theID ),
    theModule( right.theModule )
{;}

TReadoutSegment::~TReadoutSegment()
{;}

TDataSegment TReadoutSegment::ReadData()
{
  TDataSegment segment( theID );
  if ( theModule == 0 ) {
    for ( Tint i = 0; i < (Tint)size(); i ++ )
      segment.push_back( ( (*this)[ i ] ).ReadData() );
  } else {
    theModule -> FillData( segment );
  }

  return( segment );
}

Tostream& operator<<( Tostream& tos, const TReadoutSegment& right )
{
  Tstring head = Twspace + Twspace + "* Readout Segment, ";
  tos << head << "ID: " << right.theID;
  tos << Twspace << "Capacity: " << right.capacity();
  tos << Twspace << "Entry: " << right.size();

  if ( right.empty() )
    return( tos );
  
  tos << Tendl;

  for ( Tint i = 0; i < (Tint)right.size(); i ++ ) {
    tos << right[ i ];
    if ( i != (Tint)right.size() - 1 )
      tos << Tendl;
  }

  return( tos );
}

const TReadoutSegment& TReadoutSegment::operator=( const TReadoutSegment& right )
{
  *( (TReadoutElementList*)this ) = *( (TReadoutElementList*)(&right) );
  theID = right.theID;
  theModule = right.theModule;
  return( *this );
}

Tbool TReadoutSegment::operator==( const TReadoutSegment& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutElementList*)this ) == *( (TReadoutElementList*)(&right) ) );
  ret &= ( theID == right.theID );
  ret &= ( theModule == right.theModule );
  return( ret );
}

Tbool TReadoutSegment::operator!=( const TReadoutSegment& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutElementList*)this ) != *( (TReadoutElementList*)(&right) ) );
  ret &= ( theID != right.theID );
  ret &= ( theModule != right.theModule );
  return( ret );
}
