// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TREADOUTSEGMENT_HH
#define __TREADOUTSEGMENT_HH

#include "TGlobals.hh"
#include "TReadoutElementList.hh"

class TModule;
class TDataSegment;

class TReadoutSegment
  : public TReadoutElementList
{

  private:
    Tint theID;
    TModule* theModule;

  public:
    TReadoutSegment( Tint id = tIDunknown );
    TReadoutSegment( TModule* module, Tint id = tIDunknown );
    TReadoutSegment( const TReadoutSegment& right );
    ~TReadoutSegment();

  public:
    const TReadoutSegment& operator=( const TReadoutSegment& right );
    Tbool operator==( const TReadoutSegment& right ) const;
    Tbool operator!=( const TReadoutSegment& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TReadoutSegment& right );
  public:
    TDataSegment ReadData();

  public:
    Tint GetID() const;
    Tvoid SetID( Tint id );
    TModule* GetModule() const;
    Tvoid SetModule( TModule* module );

};

inline Tint TReadoutSegment::GetID() const
{
  return( theID );
}

inline Tvoid TReadoutSegment::SetID( Tint id )
{
  theID = id;
  return;
}

inline TModule* TReadoutSegment::GetModule() const
{
  return( theModule );
}

inline Tvoid TReadoutSegment::SetModule( TModule* module )
{
  theModule = module;
  return;
}

#endif
