// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TRunManager.hh"
#include "TCommand.hh"
#include "TExitCommand.hh"
#include "TListCommand.hh"
#include "TDateCommand.hh"
#include "TShowRunManagerCommand.hh"
#include "TShowNetworkStatusCommand.hh"
#include "TReadFileCommand.hh"
#include "TShellCommand.hh"
#include "TStartCommand.hh"
#include "TStopCommand.hh"

TRunManager* TRunManager::theRunManager = 0;

TRunManager::TRunManager( TUserInterface* ui )
  : theStatus( tStatusDead ), theWaitingCommands(), theUserInterface( ui )
{
  //GetRunManagerΤ긫ľ
  if ( theUserInterface != 0 ) {
    SetUserCommand( new TExitCommand() );
    SetUserCommand( new TListCommand() );
    SetUserCommand( new TDateCommand() );
    SetUserCommand( new TShowRunManagerCommand() );
    SetUserCommand( new TShowNetworkStatusCommand() );
    SetUserCommand( new TReadFileCommand() );
    SetUserCommand( new TShellCommand() );
    //SetUserCommand( new TStartCommand() );
    //SetUserCommand( new TStopCommand() );
  }
  theRunManager = this;
  theStatus = tStatusStandby;
}

TRunManager::~TRunManager()
{
  theStatus = tStatusDead;
  if ( theUserInterface )
    delete theUserInterface;
}

Tvoid TRunManager::SessionStart() const
{
  theUserInterface -> SessionStart();
  return;
}

Tint TRunManager::SetUserCommand( TCommand* command ) const
{
  if ( theUserInterface == 0 ) {
    Tcerr << "TRunManager::SetUserCommand: unset user interface." << Tendl;
    return( -EFAULT );
  }
  return( theUserInterface -> AddCommand( command ) );
}

Tvoid TRunManager::ShowStatus() const
{
  Tcout << "Status: ";
  switch ( theStatus ) {
    case tStatusStandby:
      Tcout << "Standby - [start] or [stop] command is acceptable." << Tendl;
      break;
    case tStatusReady:
      Tcout << "Ready - waiting begin of transaction(trigger), [pause] command is acceptable." << Tendl;
      break;
    case tStatusBusy:
      Tcout << "Busy - just taking data from HW/SW." << Tendl;
      break;
    case tStatusIdle:
      Tcout << "Idle - if accept [resume] command, the status is going to transit Ready." << Tendl;
      break;
    case tStatusDead:
      Tcout << "Dead - not allocate, or trouble ?" << Tendl;
      break;
    case tStatusUnknown:
    default:
      Tcout << "Unknown - unknown status." << Tendl;
      break;
  }
  return;
}
