// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TStartCommand.hh"
#include "TRunManager.hh"
#include "TRunAction.hh"

static const Tstring name = "start";
static const Tstring desc = "start a run. ex) " + name + " 100 <- run number";

TStartCommand::TStartCommand()
  : TCommand( name, desc )
{;}

TStartCommand::~TStartCommand()
{;}

Tvoid TStartCommand::Execute( const TstringList& arguments )
{
  Tint runID;
  const TRunManager* runManager = TRunManager::GetRunManager();
  TRun run = runManager -> GetRun();

  if ( !( arguments.empty() ) ) {
    if ( arguments.size() == 1 ) {
      Tstring runid = arguments[ 0 ];
      runID = atoi( runid.c_str() );
      run.SetRunNumber( runID );
    } else {
      ShowCommandDescription();
      return;
    }
  }

  TRunAction* runAction = runManager -> GetRunAction();

  if ( runAction != 0 )
    runAction -> BeginOfRunAction( run );

  runManager -> SetStatus( tStatusReady );
  return;
}
