// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TVmeDaughterBoardMemoryModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TVmeDaughterBoardMemoryModule::TVmeDaughterBoardMemoryModule( Tint baseaddress, Tint mapsize, Tint nsamples )
  : TVmeModule( 1, baseaddress, mapsize, tA32D32dma ),
    theNumberOfSampling( nsamples )
{;}

TVmeDaughterBoardMemoryModule::TVmeDaughterBoardMemoryModule( const TVmeDaughterBoardMemoryModule& right )
  : TVmeModule( right ),
    theNumberOfSampling( right.theNumberOfSampling )
{;}

TVmeDaughterBoardMemoryModule::~TVmeDaughterBoardMemoryModule()
{;}

const TVmeDaughterBoardMemoryModule& TVmeDaughterBoardMemoryModule::operator=( const TVmeDaughterBoardMemoryModule& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );
  theNumberOfSampling = right.theNumberOfSampling;
  return( *this );
}

Tbool TVmeDaughterBoardMemoryModule::operator==( const TVmeDaughterBoardMemoryModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
  ret &= ( theNumberOfSampling == right.theNumberOfSampling );
  return( ret );
}

Tbool TVmeDaughterBoardMemoryModule::operator!=( const TVmeDaughterBoardMemoryModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
  ret &= ( theNumberOfSampling != right.theNumberOfSampling );
  return( ret );
}

Tint TVmeDaughterBoardMemoryModule::Clear()
{
  return( theStatus = tStatusSuccess );
}

Tint TVmeDaughterBoardMemoryModule::Update()
{
  return( Clear() );
}

Tint TVmeDaughterBoardMemoryModule::Initialize()
{
  return( Clear() );
}

Tvoid TVmeDaughterBoardMemoryModule::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    TUlong* membase = (TUlong*)theModuleBaseAddress;
    TUlong databuf;
    TUshort data[ theNumberOfSampling ];

    for ( Tint j = 0; j < theNumberOfSampling; j ++ ) {
      databuf = *membase;
      data[ i ] = (TUshort)( databuf & 0x0000ffff );
      membase ++;
    }
 
    TDataElement element( data, tTypeShort, i );
    ( (TDataElementList*)(&segment) ) -> push_back( element );
  }

  return;
}

Tvoid TVmeDaughterBoardMemoryModule::FillData( const TDataElement& element )
{
  TUlong* membase = (TUlong*)theModuleBaseAddress;
  TUlong databuf;
  TUshort data[ theNumberOfSampling ];

  for ( Tint i = 0; i < theNumberOfSampling; i ++ ) {
    databuf = *membase;
    data[ i ] = (TUshort)( databuf & 0x0000ffff );
    membase ++;
  }

  Tint ch = element.GetID();
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TVmeDaughterBoardMemoryModule::FillData: invalid ID" << Tendl;
    Tint tmp = -EFAULT;
    theStatus = -EFAULT;
    ((TDataElement*)(&element)) -> FillData( &tmp, tTypeInt );
  } else {
    ((TDataElement*)(&element)) -> FillData( data, tTypeShort, theNumberOfSampling );
  }

  return;
}
