// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TVmeRpv130Module.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TVmeRpv130Module::TVmeRpv130Module( Tint baseaddress, Tint mapsize, Tint nch, Tint readmode )
  : TVmeModule( nch, baseaddress, mapsize, tA16D16 ),
    theReadoutMode( readmode )
{;}

TVmeRpv130Module::TVmeRpv130Module( const TVmeRpv130Module& right )
  : TVmeModule( right ), theReadoutMode( right.theReadoutMode )
{;}

TVmeRpv130Module::~TVmeRpv130Module()
{;}

const TVmeRpv130Module& TVmeRpv130Module::operator=( const TVmeRpv130Module& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );
  theReadoutMode = right.theReadoutMode;
  return( *this );
}

Tbool TVmeRpv130Module::operator==( const TVmeRpv130Module& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
  ret &= ( theReadoutMode == right.theReadoutMode );
  return( ret );
}

Tbool TVmeRpv130Module::operator!=( const TVmeRpv130Module& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
  ret &= ( theReadoutMode != right.theReadoutMode );
  return( ret );
}

Tint TVmeRpv130Module::Clear()
{
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 0, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 1, 1 );
  //*( (TUshort*)( theModuleBaseAddress + CSR1 ) ) |= 0xff;

  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 0, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 1, 1 );
  //*( (TUshort*)( theModuleBaseAddress + CSR2 ) ) |= 0xff;
  return( theStatus = tStatusSuccess );
}

Tint TVmeRpv130Module::Update()
{
  return( Clear() );
}

Tint TVmeRpv130Module::Initialize()
{
  Clear();
  Disable();
  return( theStatus = tStatusSuccess );
}

Tvoid TVmeRpv130Module::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    TUshort data = Read( i );
    TDataElement element( &data, tTypeShort, i );
    ( (TDataElementList*)(&segment) ) -> push_back( element );
  }
  return;
}

Tvoid TVmeRpv130Module::FillData( const TDataElement& element )
{
  Tint ch = element.GetID();
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::FillData: invalid ID" << Tendl;
    Tint tmp = -EFAULT;
    theStatus = -EFAULT;
    ( (TDataElement*)(&element) ) -> FillData( &tmp, tTypeInt );
  } else {
    TUshort data = Read( ch );
    ( (TDataElement*)(&element) ) -> FillData( &data, tTypeShort );
  }
  return;
}

Tvoid TVmeRpv130Module::Pulse()
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ )
    Pulse( i );
  return;
}

Tvoid TVmeRpv130Module::Pulse( int channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::Pulse: invalid ID" << Tendl;
    return;
  }
  setBit( (TUshort*)( theModuleBaseAddress + PULSE ), channel, 1 );
  return;
}

Tvoid TVmeRpv130Module::Level()
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ )
    Level( i );
  return;
}

Tvoid TVmeRpv130Module::Level( int channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::Level: invalid ID" << Tendl;
    return;
  }
  setBit( (TUshort*)( theModuleBaseAddress + LEVEL ), channel, 1 );
  return;
}

Tvoid TVmeRpv130Module::Enable()
{
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 4, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 6, 1 );
  //*( (TUshort*)( theModuleBaseAddress + CSR1 ) ) |= 0x50;

  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 4, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 6, 1 );
  //*( (TUshort*)( theModuleBaseAddress + CSR2 ) ) |= 0x50;
  return;
}

Tvoid TVmeRpv130Module::Disable()
{
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 4, 0 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 6, 0 );
  //*( (TUshort*)( theModuleBaseAddress + CSR1 ) ) |= 0xaf;

  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 4, 0 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 6, 0 );
  //*( (TUshort*)( theModuleBaseAddress + CSR2 ) ) |= 0xaf;
  return;
}

TUshort TVmeRpv130Module::Read()
{
  TUshort data;
  switch ( theReadoutMode ) {
    case tReadoutWithLatch1:
      data = *( (TUshort*)( theModuleBaseAddress + LATCH1 ) );
    case tReadoutWithLatch2:
      data = *( (TUshort*)( theModuleBaseAddress + LATCH2 ) );
    case tReadoutWithRSFF:
      data = *( (TUshort*)( theModuleBaseAddress + RSFF ) );
    case tReadoutWithThrough:
      data = *( (TUshort*)( theModuleBaseAddress + THROUGH ) );
    default:
      data = *( (TUshort*)( theModuleBaseAddress + RSFF ) );
  }
  data &= 0x00ff;
  return( data );
}

TUshort TVmeRpv130Module::Read( Tint channel )
{
  TUshort data;
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::Read: invalid ID" << Tendl;
    theStatus = -EFAULT;
    data = EFAULT;
  } else {
    data = Read();
    data = data >> channel;
    data = data & 0x01;
  }
  return( data );
}
