// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TOutputObjectFile.hh"
#include "TVmeRpv130Module.hh"

int main( int argc, char** argv, char** envv )
{
  const Tint baseaddress = 0x1000;
  TVmeRpv130Module rpv130( baseaddress );

  while ( 1 ) {
    cout << "rpv130.Enable()" << endl;
    rpv130.Enable();

    cout << "rpv130.Read()" << endl;
    rpv130.Read();
    for ( int i = 0; i < rpv130.GetNumberOfChannels(); i ++ ) {
      cout << "rpv130.Read(" << i << ")" << endl;
      rpv130.Read( i );
    }

    cout << "rpv130.Pulse()" << endl;
    rpv130.Pulse();
    for ( int i = 0; i < rpv130.GetNumberOfChannels(); i ++ ) {
      cout << "rpv130.Pulse(" << i << ")" << endl;
      rpv130.Pulse( i );
    }

    cout << "rpv130.Level()" << endl;
    rpv130.Level();
    for ( int i = 0; i < rpv130.GetNumberOfChannels(); i ++ ) {
      cout << "rpv130.Level(" << i << ")" << endl;
      rpv130.Level( i );
    }

    cout << "rpv130.Clear()" << endl;
    rpv130.Clear();

    cout << "rpv130.Disable()" << endl;
    rpv130.Enable();

    sleep( 2 );
  }
  return( 0 );
}


// int main( int argc, char** argv, char** envv )
// {
//   if ( argc != 2 ) {
//     Tcerr << "usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
//     return( -1 );
//   }
//   const Tint nevent = atoi( argv[ 1 ] );
//   const Tstring filename = "test.obj";
//   TOutputObjectFile* ofile = new TOutputObjectFile( filename );
//   Tint datasize1 = 0;
//   Tint datasize2 = 0;

//   TSoftwareScalerModule scaler;
//   TSoftwareTimerModule timer;
//   TSoftwareClockModule clock;
//   TSoftwareAdcModule adc;

//   TReadoutList list1( 1000 );
//   TReadoutSection sec1( 1100 );
//   TReadoutSegment seg1( &scaler, 1100 );
//   TReadoutSegment seg2( &clock, 1200 );
//   TReadoutSegment seg3( &timer, 1300 );
//   TReadoutSegment seg4( &adc, 1400 );
//   sec1.push_back( seg1 );
//   sec1.push_back( seg2 );
//   sec1.push_back( seg3 );
//   sec1.push_back( seg4 );
//   list1.push_back( sec1 );

//   for ( Tint i = 0; i < nevent; i ++ ) {
//     TDataRecord record = list1.ReadData();
//     ofile -> WriteData( record );
//     datasize1 += record.GetDataSize();
//     datasize2 += ofile -> GetDataSize();

//     scaler.Update();
//     clock.Update();
//     timer.Update();
//     adc.Update();
//   }


//   Tcout << Tendl;
//   Tcout << Ttab << datasize1 << Tslash << datasize2;
//   Tcout << Tspace << "byte data has been written down " << filename << Tendl;
//   Tcout << Tendl;

//   delete ofile;

//   return( 0 );
// }
