#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <fstream.h>
#include <signal.h>
#include <sys/shm.h>

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
/*  semun  <sys/sem.h> ˴ޤޤƤ */
#else
/* X/OPEN ˽ʤмʬȤǰʲΤ褦ʤФʤʤ */
union semun {
  int val;                    /* value for SETVAL */
  struct semid_ds *buf;       /* buffer for IPC_STAT, IPC_SET */
  unsigned short int *array;  /* array for GETALL, SETALL */
  struct seminfo *__buf;      /* buffer for IPC_INFO */
};
#endif



void begin( int id );
void end( int id );
void dump( int id, char* str );
void critical();

void setclient( int n );
int getclient( );
void catchsignal( int sig );

enum { R, W, N_SEMAPHORE, N_CLIENT = 3 };

static int shmid;
int main( int argc, char** argv )
{
  string projectname = "/tmp/test";

  int id = semget( ftok( projectname.c_str(), 'G' ), 0, 0644 );

  shmid = shmget( (key_t)1234, 0, 0644 );
  int n = getclient() + 1;
  setclient( n );
  signal( SIGINT, catchsignal );

  while ( 1 ) {
    begin( id );
    critical();
    end( id );
  }

  return( 0 );
}

void begin( int id )
{
  if ( semctl( id, R, GETPID, 0 ) == getpid() ) {
    struct sembuf sem_b2 = { W, 0, SEM_UNDO };
    if ( semop( id, &sem_b2, 1 ) == -1 )
      perror( 0 );
  }
  struct sembuf sem_b1 = { R, -1, SEM_UNDO };
  if ( semop( id, &sem_b1, 1 ) == -1 )
    perror( 0 );

  dump( id, "begin()" );

  return;
}

void end( int id )
{
  struct sembuf sem_b1 = { W, +1, SEM_UNDO };
  if ( semop( id, &sem_b1, 1 ) == -1 )
    perror( 0 );

  dump( id, "end()" );

  return;
}

void dump( int id, char* str )
{
  for ( int i = 0; i < N_SEMAPHORE; i ++ ) {
    cout << "semaphore value: " << semctl( id, i, GETVAL, 0 );

    // ޥեԤ
    cout << ", #wait process: " << semctl( id, i, GETNCNT, 0);

    // ޥեͤ0ˤʤΤԤäƤ
    cout << ", #wait 0 semaphore: " << semctl( id, i, GETZCNT, 0);

    cout << ", " << str << endl;
  }
  return;
}

void critical()
{
  cout << "Now, critical section ..." << endl;
  //sleep( 2 );
  return;
}


void setclient( int n )
{
  unsigned long* val = (unsigned long*)shmat( shmid, 0, 0 );
  *val = n;
  return;
}

int getclient( )
{
  unsigned long* val = (unsigned long*)shmat( shmid, 0, 0 );
  return( (int)(*val) );
}

void catchsignal( int sig )
{
  cout << "get the signal " << sig << ", decrement client." << endl;
  int n = getclient() - 1;
  setclient( n );
  exit( 0 );
}
