#include <iostream.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <fstream.h>
#include <signal.h>
#include <string>
#include <sys/shm.h>

int initialize( string project );

void begin( int id );
void end( int id );
void remove( int id );
void catchsignal( int sig );
void dump( int id, char* str );
void critical();

static int semid;
static int shmid;
unsigned long* nclients;
// N_CLIENT ѤʤΤȤݾڤ
enum { R, W, N_SEMAPHORE, N_CLIENT = 3 };

void cliententry();


int main( int argc, char** argv )
{
  string projectname = "/tmp/test";
  semid = initialize( projectname );


  while ( 1 ) {
    begin( semid );
    critical();
    end( semid );
  }

  return( 0 );
}

int initialize( string pname )
{
  signal( SIGINT, catchsignal );

  cliententry();

  //keyǤʤʸǲ褹
  int id = semget( ftok( pname.c_str(), 'G' ), N_SEMAPHORE, 0644 | IPC_CREAT );
  short initval[ N_SEMAPHORE ] = { (short)(*nclients), (short)(*nclients) };
  if ( semctl( id, 0, SETALL, &initval ) == -1 )
    perror( 0 );

//   struct sembuf sem_b = { R, -N_CLIENT, SEM_UNDO };
//   if ( semop( id, &sem_b, 1 ) == -1 )
//     perror( 0 );

  return( id );
}

void begin( int id )
{
  //饤ȤοưŪ˲褹Ȥߤͤ shared memory
  //饤ȤǤʤʤä顢饤Ȥο餹,Ȥ
  //饤Ȥʤä餽Τޤ޽³褦ˤ
  pid_t pid = getpid();
  if ( fork() == 0 )
    exit( 0 );
  else
    wait( 0 );

  if ( semctl( id, R, GETPID, 0 ) == pid ) {
    if ( semctl( semid, R, SETVAL, 0 ) == -1 )
      perror( 0 );
    if ( semctl( semid, W, SETVAL, 0 ) == -1 )
      perror( 0 );
  } else {

    struct sembuf sem_b1 = { W, -(short)(*nclients), SEM_UNDO };
    if ( semop( id, &sem_b1, 1 ) == -1 )
      perror( 0 );
  }
  

  dump( id, "begin()" );
  return;
}

void end( int id )
{
  if ( semctl( semid, R, SETVAL, (short)*nclients ) == -1 )
    perror( 0 );
  

  dump( id, "end()" );

  return;
}

void dump( int id, char* str )
{
  for ( int i = 0; i < N_SEMAPHORE; i ++ ) {
    cout << "semaphore value: " << semctl( id, i, GETVAL, 0 );

    // ޥեԤ
    cout << ", #wait process: " << semctl( id, i, GETNCNT, 0);

    // ޥեͤ0ˤʤΤԤäƤ
    cout << ", #wait 0 semaphore: " << semctl( id, i, GETZCNT, 0);

    cout << ", " << str << endl;
  }
  return;
}

void remove( int id )
{
  semctl( id, 0, IPC_RMID, 0 );
  shmctl( shmid, IPC_RMID, 0 );
  return;
}

void critical()
{
  cout << "Now, critical section ..." << endl;
  sleep( 3 );
  return;
}

void catchsignal( int sig )
{
  cout << "get the signal " << sig << ", remove semaphore resource." << endl;
  remove( semid );
  exit( 0 );
}

void cliententry()
{
  shmid = shmget( (key_t)1234, sizeof( unsigned long ), 0644 | IPC_CREAT );
  nclients = (unsigned long*)shmat( shmid, 0, 0 );

  *nclients = 0;

  return;
}
