// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TANALYSISSTATION_HH
#define __TANALYSISSTATION_HH

#include "TGlobals.hh"
#include "TRoot1DHistogram.hh"
#include "TRootGraph.hh"

class TAnalysisDataExtractor;
class TDataRecord;
class TRootAnalyser;

class TAnalysisStation
{
  private:
    static TAnalysisStation* theAnalysisStation;

  private:
    TRootAnalyser* theAnalyser;

  public:
    TAnalysisStation( TRootAnalyser* analyser = 0 );
    virtual ~TAnalysisStation();

  public:
    virtual TRootAnalyser* GetRootAnalyser() const;

    virtual Tvoid Fill1DHistogram( TRoot1DHistogram& hist, 
				   TDataRecord& record, 
				   TAnalysisDataExtractor& extractor );
    virtual Tvoid FillGraph( TRootGraph& graph,
			     TDataRecord& record,
			     TAnalysisDataExtractor& extractor );
    virtual Tvoid Update();
    virtual Tvoid DivideCanvas( Tint x, Tint y );
    virtual Tvoid MoveCanvas( Tint ptr );
    virtual Tvoid EventLoop( Tbool ret = Tfalse );

    

  public:
    static const TAnalysisStation* GetAnalysisStation();

};

inline const TAnalysisStation* TAnalysisStation::GetAnalysisStation()
{
  if ( theAnalysisStation == 0 )
    theAnalysisStation = new TAnalysisStation();
  return( theAnalysisStation );
}

inline TRootAnalyser* TAnalysisStation::GetRootAnalyser() const
{
  return( theAnalyser );
}

#endif
