// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TEvent.hh"

TEvent::TEvent( Tint eventID, const TDataRecord& eventData )
  : theEventID( eventID ), theDataRecord( eventData )
{;}

TEvent::TEvent( const TEvent& right )
  : theEventID( right.theEventID ), 
    theDataRecord( right.theDataRecord )
{;}

TEvent::~TEvent()
{;}

const TEvent& TEvent::operator=( const TEvent& right )
{
  theEventID = right.theEventID;
  theDataRecord = right.theDataRecord;
  return( *this );
}

Tbool TEvent::operator==( const TEvent& right ) const
{
  if ( theEventID == right.theEventID && theDataRecord == right.theDataRecord )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TEvent::operator!=( const TEvent& right ) const
{
  if ( theEventID != right.theEventID || theDataRecord != right.theDataRecord )
    return( Ttrue );
  else
    return( Tfalse );
}

Tvoid TEvent::Clear()
{
  theDataRecord.clear();
  theEventID = 0;
  return;
}
