// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TModule.hh"

TModule::TModule( Tint nchannel, Tint id )
  : theNumberOfChannels( nchannel ), theID( id ), theStatus( tStatusSuccess )
{;}

TModule::TModule( const TModule& right )
  : theNumberOfChannels( right.theNumberOfChannels ), theID( right.theID ),
    theStatus( right.theStatus )
{;}

TModule::~TModule()
{;}

const TModule& TModule::operator=( const TModule& right )
{
  theNumberOfChannels = right.theNumberOfChannels;
  theID = right.theID;
  theStatus = right.theStatus;
  return( *this );
}

Tbool TModule::operator==( const TModule& right ) const
{
  if ( theNumberOfChannels == right.theNumberOfChannels && 
       theID == right.theID && 
       theStatus == right.theStatus )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TModule::operator!=( const TModule& right ) const
{
  if ( theNumberOfChannels != right.theNumberOfChannels ||
       theID != right.theID ||
       theStatus != right.theStatus )
    return( Ttrue );
  else
    return( Tfalse );
}
