// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TOutputObjectFile.hh"
#include "TObjectFilter.hh"

TOutputObjectFile::TOutputObjectFile( const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( tFileStream )
{;}

TOutputObjectFile::TOutputObjectFile( TObjectFilter* filter, const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( filter, tFileStream )
{;}

TOutputObjectFile::~TOutputObjectFile()
{;}

Tint TOutputObjectFile::WriteData( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;
  if ( HasFilter() )
    theDataSize = theObjectFilter -> Filter( object, this );
  else
    theDataSize = object.WriteData( this );
  return( theDataSize );
}
