// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TReadoutList.hh"
#include "TDataRecord.hh"

TReadoutList::TReadoutList( Tint id )
  : TReadoutSectionList(), theID( id )
{;}

TReadoutList::TReadoutList( const TReadoutList& right )
  : TReadoutSectionList( right ), theID( right.theID )
{;}

TReadoutList::~TReadoutList()
{;}

TDataRecord TReadoutList::ReadData()
{
  TDataRecord record( theID );

  for ( Tint i = 0; i < (Tint)size(); i ++ )
    record.push_back( ( (*this)[ i ] ).ReadData() );

  return( record );
}

Tostream& operator<<( Tostream& tos, const TReadoutList& right )
{
  Tstring head = "* Readout List, ";
  tos << head << "ID: " << right.theID;
  tos << Twspace << "Capacity: " << right.capacity();
  tos << Twspace << "Entry: " << right.size();

  if ( right.empty() )
    return( tos );
  
  tos << Tendl;

  for ( Tint i = 0; i < (Tint)right.size(); i ++ ) {
    tos << right[ i ];
    if ( i != (Tint)right.size() - 1 )
      tos << Tendl;
  }

  return( tos );
}

const TReadoutList& TReadoutList::operator=( const TReadoutList& right )
{
  *( (TReadoutSectionList*)this ) = *( (TReadoutSectionList*)(&right) );
  theID = right.theID;
  return( *this );
}

Tbool TReadoutList::operator==( const TReadoutList& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutSectionList*)this ) == *( (TReadoutSectionList*)(&right) ) );
  ret &= ( theID == right.theID );
  return( ret );
}

Tbool TReadoutList::operator!=( const TReadoutList& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutSectionList*)this ) != *( (TReadoutSectionList*)(&right) ) );
  ret &= ( theID != right.theID );
  return( ret );
}
