// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TREADOUTSECTION_HH
#define __TREADOUTSECTION_HH

#include "TGlobals.hh"
#include "TReadoutSegmentList.hh"

class TDataSection;

class TReadoutSection
  : public TReadoutSegmentList
{

  private:
    Tint theID;

  public:
    TReadoutSection( Tint id = tIDunknown );
    TReadoutSection( const TReadoutSection& right );
    ~TReadoutSection();

  public:
    const TReadoutSection& operator=( const TReadoutSection& right );
    Tbool operator==( const TReadoutSection& right ) const;
    Tbool operator!=( const TReadoutSection& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TReadoutSection& right );

  public:
    TDataSection ReadData();    

  public:
    Tint GetID() const;
    Tvoid SetID( Tint id );

};

inline Tint TReadoutSection::GetID() const
{
  return( theID );
}

inline Tvoid TReadoutSection::SetID( Tint id )
{
  theID = id;
  return;
}

#endif
