// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TAnalysisStation.hh"
#include "TRootAnalyser.hh"
#include "TRoot1DHistogram.hh"
#include "TRootGraph.hh"
#include "TSoftwareAdcModule.hh"
#include "TDataRecord.hh"

#include "Ex1DHistogramExtractor.hh"
#include "ExGraphExtractor.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ 1 ] );


  TSoftwareAdcModule adc;
  TReadoutList list( 1000 );
  TReadoutSection sec( 1100 );
  TReadoutSegment seg( &adc, 1110 );
  sec.push_back( seg );
  list.push_back( sec );

  TAnalysisStation* station =
    new TAnalysisStation( new TRootAnalyser( 600, 800 ) );

  TRoot1DHistogram hist = TRoot1DHistogram( "demo", "1D HISTOGRAM", 4095, 0, 4095 );
  TRootGraph graph;
  graph.SetMarkerStyle( 8 );
  graph.SetMarkerSize( 1.2 );

  Ex1DHistogramExtractor histext;
  ExGraphExtractor grext;

  station -> DivideCanvas( 1, 2 );
  TDataRecord record;
  for ( Tint i = 0; i < nevent; i ++ ) {
    record = list.ReadData();
    
    station -> Fill1DHistogram( hist, record, histext );
    station -> MoveCanvas( 1 );
    hist.Draw();
    //hist.Fit( "gaus" );  // Fit٤

    station -> FillGraph( graph, record, grext );
    station -> MoveCanvas( 2 );

    graph.Draw( "ap" );

    if ( i % 10 == 0 )  // 񤯤Ȥ٤
      station -> Update();

    adc.Update();
  }
  station -> EventLoop();
  
  return( 0 );
}
