// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TOutputObjectSharedMemory.hh"
#include "TStreamableObject.hh"
#include "TObjectFilter.hh"

TOutputObjectSharedMemory::TOutputObjectSharedMemory( Tint memsize, Tint maxevt )
  : TObjectSharedMemory( memsize, maxevt ),
    TOutputObjectStream( tSharedMemoryStream ),
    theSigIntHandler( 0 ), theSigSegvHandler( 0 )
{
  theSigIntHandler = new TSignalHandler( SIGINT, this );
  theSigIntHandler -> Enable();
  theSigSegvHandler = new TSignalHandler( SIGSEGV, this );
  theSigSegvHandler -> Enable();
}

TOutputObjectSharedMemory::TOutputObjectSharedMemory( TObjectFilter* filter, Tint memsize, Tint maxevt )
  : TObjectSharedMemory( memsize, maxevt ),
    TOutputObjectStream( filter, tSharedMemoryStream ),
    theSigIntHandler( 0 ), theSigSegvHandler( 0 )
{
  theSigIntHandler = new TSignalHandler( SIGINT, this );
  theSigIntHandler -> Enable();
  theSigSegvHandler = new TSignalHandler( SIGSEGV, this );
  theSigSegvHandler -> Enable();
}

TOutputObjectSharedMemory::~TOutputObjectSharedMemory()
{
  Detach();
  Remove();
  delete theSigIntHandler;
  delete theSigSegvHandler;
}

Tint TOutputObjectSharedMemory::WriteData( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;


  if ( theCurrentPositionOfMemorySpace == theMaxEvent - 1 ) {
    // return to top
    theAddress = theBaseAddress;
    theCurrentPositionOfMemorySpace = 0;
  }
    
  if ( HasFilter() )
    theDataSize = theObjectFilter -> Filter( object, this );
  else
    theDataSize = object.WriteData( this );

  if ( theDataSize > 0 )
    theCurrentPositionOfMemorySpace ++;

  //theAddressDataRecordǤ
  //( (Tchar*)theAddress ) += theDataSize;

  return( theDataSize );
}
