// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "ExGraphExtractor.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

ExGraphExtractor::ExGraphExtractor()
  : TAnalysisDataExtractor()
{;}

ExGraphExtractor::~ExGraphExtractor()
{;}

Tvoid ExGraphExtractor::Extract( const TDataRecord& record )
{
  static const Tint findsegID = 1110;
  static const Tint chx = 4;
  static const Tint chy = 5;
  TDataSection section;
  TDataSegment segment;
  TDataElement element;
  Tint databuf[ 2 ];
  TdoubleList linebuf;
  TMultipleData mdata;


  for ( Tsize_t i = 0; i < record.size(); i ++ ) {
    section = record[ i ];
    for ( Tsize_t j = 0; j < section.size(); j ++ ) {
      segment = section[ j ];
      if ( segment.GetID() == findsegID ) {
	element = segment[ chx ];
	databuf[ 0 ] = *( (Tint*)( element.GetData() ) );
	element = segment[ chy ];
	databuf[ 1 ] = *( (Tint*)( element.GetData() ) );

	linebuf.push_back( ( (Tdouble)databuf[ 0 ] ) );
	linebuf.push_back( ( (Tdouble)databuf[ 1 ] ) );

	mdata.push_back( linebuf );
	theMultipleData = mdata;

      }
    }
  }

  return;
}
