// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "AsoReadoutList.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TVmeMpx201aModule.hh"

AsoReadoutList::AsoReadoutList()
{
  theScaler = new TSoftwareScalerModule( 1 );
  theClock = new TSoftwareClockModule( 2 );

  const Tint mpxbase = 0xc000;



  //const Tint nblock = 3030;  // ԥ8ץTI
  //const Tint nblock = 288;  // ԥ룱ץ
  //const Tint nblock = 4608;  // ԥ룳ץ
  //const Tint nblock = 2304;  // ԥ16ץ
  //const Tint nblock = 1152;  // ԥ8ץ
  const Tint nblock = 700;
 


  theFadc = new TVmeMpx201aModule( mpxbase, nblock );

  theReadoutList = TReadoutList( 1000 );


  TReadoutSection sec1( 1100 );
  TReadoutSegment seg1( theScaler, 1110 );
  TReadoutSegment seg2( theClock, 1120 );
  sec1.push_back( seg1 );
  sec1.push_back( seg2 );

  TReadoutSection sec2( 1200 );
  TReadoutSegment seg3( theFadc, 1210 );
  sec2.push_back( seg3 );

  theReadoutList.push_back( sec1 );
  theReadoutList.push_back( sec2 );
}

AsoReadoutList::~AsoReadoutList()
{
  delete theScaler;
  delete theClock;
  delete theFadc;
}
