// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "DarkReadoutList.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TVmeMpx201aModule.hh"

DarkReadoutList::DarkReadoutList()
{
  theScaler = new TSoftwareScalerModule( 1 );
  theClock = new TSoftwareClockModule( 2 );

  const Tint mpxbase = 0xc000;

  //const Tint nblock = 288;  // ԥ룱ץ
  const Tint nblock = 2;  // mattaku e wo kakanaikara herasita

 


  theFadc = new TVmeMpx201aModule( mpxbase, nblock );

  theReadoutList = TReadoutList( 1000 );


  TReadoutSection sec1( 1100 );
  TReadoutSegment seg1( theScaler, 1110 );
  TReadoutSegment seg2( theClock, 1120 );
  sec1.push_back( seg1 );
  sec1.push_back( seg2 );

  TReadoutSection sec2( 1200 );
  TReadoutSegment seg3( theFadc, 1210 );
  sec2.push_back( seg3 );

  theReadoutList.push_back( sec1 );
  theReadoutList.push_back( sec2 );
}

DarkReadoutList::~DarkReadoutList()
{
  delete theScaler;
  delete theClock;
  delete theFadc;
}
