// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TROOTANALYSER_HH
#define __TROOTANALYSER_HH

#include "TGlobals.hh"
#include "TRootApplication.hh"
#include "TRootFile.hh"
#include "TAnalyser.hh"

class TMatrixElement;

class TRootAnalyser
  : public TAnalyser
{

  private:
    static TRootApplication* theRootApplication;

  private:
    TRootFile* theRootFile;

  public:
    TRootAnalyser();
    ~TRootAnalyser();

  public:
    Tvoid OpenCanvas( const Tstring& id, const Tstring& title, Tint width, Tint height );
    Tvoid ClearCanvas( const Tstring& id );
    Tvoid CloseCanvas( const Tstring& id );
    Tvoid Create1DHistogram( const Tstring& id, const Tstring& title, Tint nbin, Tdouble min, Tdouble max );
    Tvoid Create2DHistogram( const Tstring& id, const Tstring& title, Tint xbin, Tdouble xmin, Tdouble xmax, Tint ybin, Tdouble ymin, Tdouble ymax );
    Tvoid CreateAppendGraph( const Tstring& id, const Tstring& title );
    Tvoid CreateSubstituteGraph( const Tstring& id, const Tstring& title );
    Tvoid Fill( const TMatrixElement& matrix );
    Tvoid Clear( const Tstring& id );
    Tvoid Remove( const Tstring& id );
    Tvoid Update( const Tstring& id );

  public:
    TRootFile* GetRootFile() const;
    Tvoid SetRootFile( TRootFile* file );

  public:
    Tbool IsExist( const Tstring& id ) const;
    Tbool IsOnHeap( const Tstring& id ) const;

  private:
    Tvoid fill1DHistogram( const TMatrixElement& matrix );
    Tvoid fill2DHistogram( const TMatrixElement& matrix );
    Tvoid fillAppendGraph( const TMatrixElement& matrix );
    Tvoid fillSubstituteGraph( const TMatrixElement& matrix );
    Tvoid fillNtuple( const TMatrixElement& matrix );
    Tvoid draw1DHistogram( const Tstring& id );
    Tvoid draw2DHistogram( const Tstring& id );
    Tvoid drawAppendGraph( const Tstring& id );
    Tvoid drawSubstituteGraph( const Tstring& id );
    Tvoid drawNtuple( const Tstring& id );

  public:
    static TRootApplication* GetRootApplication();

};

inline TRootApplication* TRootAnalyser::GetRootApplication()
{
  if ( theRootApplication )
    return( theRootApplication );
  return( 0 );
}

inline TRootFile* TRootAnalyser::GetRootFile() const
{
  return( theRootFile );
}

#endif
