// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TAddRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring name = "/run/addinfo";
static const Tstring desc = "add run information into the table.";

TAddRunInformationModuleCommand::TAddRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, name, desc ), TRunInformationModuleCommand( module )
{;}

TAddRunInformationModuleCommand::~TAddRunInformationModuleCommand()
{;}

Tvoid TAddRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  static const Tsize_t bufflen = 1024;

  Tstring head = "TAddRunInformationModuleCommand::Execute: ";
  if ( theRunInformationModule == 0 ) {
    Tcerr << head << "RunInformationModule does not exist." << Tendl;
    return;
  }

  Tstatus_t status = theRunManager -> GetStatus();
  if ( status == tStatusIdle || status == tStatusStandby ) {
    TRunInformationTable& table =
      theRunInformationModule -> GetRunInformationTable();
    Tstring itembuf;
    Tchar* linebuf = new Tchar[ bufflen ];
    Tcout << "Item ---> ";
    Tcin.getline( linebuf, bufflen );
    itembuf = linebuf;
    delete [] linebuf;
    Tint pos = table.FindItem( itembuf );
    if ( pos == TRunInformationTable::tNotFound ) {
      Tstring valuebuf;
      Tchar* linebuf = new Tchar[ bufflen ];
      Tcout << itembuf << ": Value ---> ";
      Tcin.getline( linebuf, bufflen );
      valuebuf = linebuf;
      delete [] linebuf;
      table.AddRow( itembuf, valuebuf );
    } else {
      Tcout << head << itembuf << " entry already exist in the table." << Tendl;
    }
  } else {
    theRunManager -> ShowStatus();
    Tcerr << head << "status of RunManager must be Standby or Idle." << Tendl;
  }
  return;
}
