// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TCOMMAND_HH
#define __TCOMMAND_HH

#include "TGlobals.hh"

class TRunManager;

class TCommand
{

  protected:
    TRunManager* theRunManager;
    Tstring theCommandName;
    Tstring theGuidance;

  public:
    TCommand( TRunManager* manager, const Tstring& name, const Tstring& guidance = "" );
    virtual ~TCommand();

  public:
    TRunManager* GetRunManager() const;
    const Tstring& GetCommandName() const;
    const Tstring& GetGuidance() const;
    Tvoid SetCommandName( const Tstring& name );
    Tvoid SetGuidance( const Tstring& guidance );

  public:
    virtual Tvoid Execute( const TstringList& arguments );
    virtual Tvoid ShowCommandDetail() const;

};

inline const Tstring& TCommand::GetCommandName() const
{
  return( theCommandName );
}

inline const Tstring& TCommand::GetGuidance() const
{
  return( theGuidance );
}

inline Tvoid TCommand::SetCommandName( const Tstring& name )
{
  theCommandName = name;
  return;
}

inline Tvoid TCommand::SetGuidance( const Tstring& guidance )
{
  theGuidance = guidance;
  return;
}

inline TRunManager* TCommand::GetRunManager() const
{
  return( theRunManager );
}

#endif
