// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TSetRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring name = "/run/setinfo";
static const Tstring desc = "set run information into the table.";

TSetRunInformationModuleCommand::TSetRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, name, desc ), TRunInformationModuleCommand( module )
{;}

TSetRunInformationModuleCommand::~TSetRunInformationModuleCommand()
{;}

Tvoid TSetRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  Tstring head = "TSetRunInformationModuleCommand::Execute: ";
  if ( theRunInformationModule == 0 ) {
    Tcerr << head << "RunInformationModule does not exist." << Tendl;
    return;
  }

  Tstatus_t status = theRunManager -> GetStatus();
  if ( status == tStatusIdle || status == tStatusStandby ) {
    if ( arguments.empty() ) {
      setInformationWithShakeHand();
    } else if ( arguments.size() == 1 ) {
      setInformationWithShakeHand( arguments[ 0 ] );
    } else if ( arguments.size() >= 2 ) {
      setInformation( arguments );
    } else {
      ShowCommandDetail();
    }
  } else {
    theRunManager -> ShowStatus();
    Tcerr << head << "status of RunManager must be Standby or Idle." << Tendl;
  }
  return;
}

Tvoid TSetRunInformationModuleCommand::setInformationWithShakeHand( const Tstring& item )
{
  TRunInformationTable& table =
    theRunInformationModule -> GetRunInformationTable();

  Tint pos = table.FindItem( item );
  if ( pos != TRunInformationTable::tNotFound ) {
    Tstring strbuf;
    static const Tsize_t bufflen = 1024;
    Tchar* linebuf = new Tchar[ bufflen ];
    Tcout << table.GetItem( pos ) << Tcolon << Tspace;
    Tcout << table.GetValue( pos ) << "---> ";
    Tcin.getline( linebuf, bufflen );
    strbuf = linebuf;
    delete [] linebuf;
    table.SetRow( item, strbuf );
  } else {
    Tstring head = "TSetRunInformationModuleCommand::setInformationWithShakeHand: ";
    Tcout << head << "not found " << item << " entry in the table." << Tendl;
  }
  return;
}

Tvoid TSetRunInformationModuleCommand::setInformationWithShakeHand()
{
  TRunInformationTable& table =
    theRunInformationModule -> GetRunInformationTable();
  TstringList itemlist = table.GetItemList();
  for ( Tsize_t i = 0; i < itemlist.size(); i ++ )
    setInformationWithShakeHand( itemlist[ i ] );
  return;
}

Tvoid TSetRunInformationModuleCommand::setInformation( const TstringList& arguments )
{
  TstringList args = arguments;
  Tstring item = args[ 0 ];

  args.erase( args.begin() );

  Tstring value;
  for ( Tsize_t i = 0; i < args.size(); i ++ ) {
    value += args[ i ];
    if ( i <= args.size() )
      value += Tspace;
  }

  TRunInformationTable& table =
    theRunInformationModule -> GetRunInformationTable();

  Tint pos = table.FindItem( item );
  if ( pos != TRunInformationTable::tNotFound ) {
    table.SetRow( item, value );
  } else {
    Tstring head = "TSetRunInformationModuleCommand::setInformation: ";
    Tcout << head << "not found " << item << " entry in the table." << Tendl;
  }
  return;
}
