// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TShellCommand.hh"

static const Tstring name = "/system/shell";
static const Tstring desc = "execute shell command.\nexample> shell ls -l\nexample> shell ps aux";

TShellCommand::TShellCommand( TRunManager* manager )
  : TCommand( manager, name, desc )
{;}

TShellCommand::~TShellCommand()
{;}

Tvoid TShellCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    ShowCommandDetail();
    return;
  }

  Tstring shcom;
  for ( Tsize_t i = 0; i < arguments.size(); i ++ ) {
    shcom += arguments[ i ];
    if ( i != arguments.size() - 1 )
      shcom += Tspace;
  }
  system( shcom.c_str() );

  return;
}
