// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TDataRecord.hh"
#include "TOutputObjectStream.hh"
#include "TOutputObjectFile.hh"
#include "TOutputObjectSocket.hh"
#include "TOutputObjectSharedMemory.hh"

TDataRecord::TDataRecord( Tint id )
  : TStreamableObject( tObjectDataRecord, id ), TDataSectionList()
{;}

TDataRecord::TDataRecord( const TDataRecord& right )
  : TStreamableObject( right ), TDataSectionList( right )
{;}

TDataRecord::~TDataRecord()
{;}

Tint TDataRecord::GetDataSize()
{
  Tint total = Tsizeof( theObjectType ) + Tsizeof( theID );
  for ( Tint i = 0; i < (Tint)size(); i ++ )
    total += ( (*this)[ i ] ).GetDataSize();
  return( total );
}

Tint TDataRecord::WriteData( TOutputObjectStream* output )
{
  Tint datasize = 0;
  Tstream_t streamtype = output -> GetStreamType();

  switch ( streamtype ) {
    case tFileStream:
      datasize = writeToFile( (TOutputObjectFile*)output );
      break;
    case tSocketStream:
      datasize = writeToSocket( (TOutputObjectSocket*)output );
      break;
    case tSharedMemoryStream:
      datasize = writeToSharedMemory( (TOutputObjectSharedMemory*)output );
      break;
    case tUnknownStream:
    default:
      return( 0 );
      break;
  }


  for ( Tint i = 0; i < (Tint)size(); i ++ )
    datasize += ( (*this)[ i ] ).WriteData( output );

  return( datasize );
}

Tostream& operator<<( Tostream& tos, const TDataRecord& right )
{
  Tstring head = "* Data Record, ";
  tos << head << "ID: " << right.theID;
  tos << Twspace << "Capacity: " << right.capacity();
  tos << Twspace << "Entry: " << right.size();

  if ( right.empty() )
    return( tos );
  
  tos << Tendl;

  for ( Tint i = 0; i < (Tint)right.size(); i ++ ) {
    tos << right[ i ];
    if ( i != (Tint)right.size() - 1 )
      tos << Tendl;
  }

  return( tos );
}

Tint TDataRecord::writeToFile( TOutputObjectFile* ofile )
{
  Tsize_t datasize = 0;
  static const Tsize_t nmemb = 1;
  Tsize_t ss = 0;


  // write object ID
  ss = fwrite( &theID, Tsizeof( theID ), nmemb, ofile -> GetFileStream() );
  if ( ss != nmemb )
    perror( "TDataRecord::writeToFile" );
  else
    datasize += Tsizeof( theID );


  // write number of entries
  Tint entry = (Tint)size();
  ss = fwrite( &entry, Tsizeof( entry ), nmemb, ofile -> GetFileStream() );
  if ( ss != nmemb )
    perror( "TDataRecord::writeToFile" );
  else
    datasize += Tsizeof( entry );

  return( (Tint)datasize );
}

Tint TDataRecord::writeToSocket( TOutputObjectSocket* osocket )
{
  Tsize_t datasize = 0;


  // send object ID
  if ( send( osocket->GetServerDescriptor(), &theID, Tsizeof( theID ), 0 ) != (Tint)( Tsizeof( theID ) ) )
    perror( "TDataRecord::writeToSocket" );
  else
    datasize += Tsizeof( theID );


  // send number of entries
  Tint entry = (Tint)size();
  if ( send( osocket->GetServerDescriptor(), &entry, Tsizeof( entry ), 0 ) != (Tint)( Tsizeof( theID ) ) )
    perror( "TDataRecord::writeToSocket" );
  else
    datasize += Tsizeof( entry );


  return( (Tint)datasize );
}

Tint TDataRecord::writeToSharedMemory( TOutputObjectSharedMemory* omemory )
{
  Tsize_t datasize = 0;
  Tint* ptr = (Tint*)( omemory -> GetAddress() );

  // write object ID
  *ptr = theID;
  datasize += Tsizeof( theID );
  ptr ++;

  // write number of entries
  Tint entry = (Tint)size();
  *ptr = entry;
  datasize += Tsizeof( entry );
  ptr ++;

  omemory -> SetAddress( ptr );

  return( (Tint)datasize );
}

const TDataRecord& TDataRecord::operator=( const TDataRecord& right )
{
  *( (TStreamableObject*)this ) = *( (TStreamableObject*)(&right) );
  *( (TDataSectionList*)this ) = *( (TDataSectionList*)(&right) );

  return( *this );
}

Tbool TDataRecord::operator==( const TDataRecord& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *((TStreamableObject*)this) == *((TStreamableObject*)(&right)) );
  ret &= ( *( (TDataSectionList*)this ) == *( (TDataSectionList*)(&right) ) );

  return( ret );
}

Tbool TDataRecord::operator!=( const TDataRecord& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *((TStreamableObject*)this) != *((TStreamableObject*)(&right)) );
  ret |= ( *((TDataSectionList*)this) != *((TDataSectionList*)(&right)) );
  return( ret );
}
