// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TEVENTMANAGER_HH
#define __TEVENTMANAGER_HH

#include "TGlobals.hh"
#include "TEvent.hh"

class TRun;
class TEventAction;

class TEventManager
{

  private:
    static TEventManager* theEventManager;

  public:
    enum { tDefaultStackSize = 100 };

  private:
    Tstatus_t theStatus;
    Tint theStackSize;
    Tint theNumberOfEvents;
    TEventAction* theEventAction;
    TEvent theEvent;

  public:
    TEventManager( Tint stacksize = tDefaultStackSize );
    virtual ~TEventManager();

  public:
    Tint GetStackSize() const;
    Tint GetNumberOfEvents() const;
    const TEvent& GetEvent() const;
    TEvent& GetEvent();
    TEventAction* GetEventAction() const;
    Tvoid SetStackSize( Tint stacksize );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetEvent( const TEvent& event );
    Tvoid SetEventAction( TEventAction* action );
    Tstatus_t GetStatus() const;
    Tvoid SetStatus( Tstatus_t status );

  public:
    virtual const TRun& RecordEvent();
    virtual const TEvent& TakeEvent();
    virtual Tvoid ShowStatus() const;
    virtual Tvoid Clear();

  public:
    static TEventManager* GetEventManager();

};

inline TEventManager* TEventManager::GetEventManager()
{
  return( theEventManager );
}

inline Tint TEventManager::GetStackSize() const
{
  return( theStackSize );
}

inline Tint TEventManager::GetNumberOfEvents() const
{
  return( theNumberOfEvents );
}

inline const TEvent& TEventManager::GetEvent() const
{
  return( theEvent );
}

inline TEvent& TEventManager::GetEvent()
{
  return( theEvent );
}

inline TEventAction* TEventManager::GetEventAction() const
{
  return( theEventAction );
}

inline Tvoid TEventManager::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid TEventManager::SetEvent( const TEvent& event )
{
  theEvent = event;
  return;
}

inline Tstatus_t TEventManager::GetStatus() const
{
  return( theStatus );
}

inline Tvoid TEventManager::SetStatus( Tstatus_t status )
{
  theStatus = status;
  return;
}

#endif
