// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TSoftwareRunInformationModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareRunInformationModule::TSoftwareRunInformationModule( Tint id )
  : TSoftwareModule( 0, id ), theRunInformationTable()
{
  theRunInformationTable.Clear();
}

TSoftwareRunInformationModule::TSoftwareRunInformationModule( const TRunInformationTable& table, Tint id )
  : TSoftwareModule( 0, id ), theRunInformationTable( table )
{
  theRunInformationTable.Clear();
}

TSoftwareRunInformationModule::TSoftwareRunInformationModule( const TSoftwareRunInformationModule& right )
  : TSoftwareModule( right ), theRunInformationTable( right.theRunInformationTable )
{;}

TSoftwareRunInformationModule::~TSoftwareRunInformationModule()
{;}

Tvoid TSoftwareRunInformationModule::FillData( const TDataSegment& segment )
{
  Tstring item;
  Tstring value;
  Tstring fill;
  for ( Tint i = 0; i < theRunInformationTable.GetNumberOfRows(); i ++ ) {
    item = theRunInformationTable.GetItem( i );
    value = theRunInformationTable.GetValue( i );
    fill = item + Ttab + value;
    TDataElement element( &fill, tTypeString, i, 1 );
    ((TDataElementList*)(&segment)) -> push_back( element );
  }
  return;
}

Tvoid TSoftwareRunInformationModule::FillData( const TDataElement& element )
{
  Tint row = element.GetID();
  Tint tmp = -EFAULT;

  if ( row < 0 || row >= theRunInformationTable.GetNumberOfRows() ) {
    Tcerr << "TSoftwareRunInformationModule::FillData: invalid ID" << Tendl;
    ((TDataElement*)(&element)) -> FillData( &tmp, tTypeInt, 1 );
  } else {
    Tstring item = theRunInformationTable.GetItem( row );
    Tstring value = theRunInformationTable.GetValue( row );
    Tstring fill = item + Ttab + value;
    ((TDataElement*)(&element)) -> FillData( &fill, tTypeString, 1 );
  }

  return;
}

const TSoftwareRunInformationModule& TSoftwareRunInformationModule::operator=( const TSoftwareRunInformationModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theRunInformationTable = right.theRunInformationTable;
  return( *this );
}

Tbool TSoftwareRunInformationModule::operator==( const TSoftwareRunInformationModule& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  retval &= ( theRunInformationTable == right.theRunInformationTable );
  return( retval );
}

Tbool TSoftwareRunInformationModule::operator!=( const TSoftwareRunInformationModule& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  retval |= ( theRunInformationTable != right.theRunInformationTable );
  return( retval );
}

Tint TSoftwareRunInformationModule::Clear()
{
  TstringList valuelist = theRunInformationTable.GetValueList();
  for ( Tsize_t i = 0; i < valuelist.size(); i ++ )
    valuelist[ i ] = "";
  theRunInformationTable.SetValueList( valuelist );
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareRunInformationModule::Update()
{
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareRunInformationModule::Initialize()
{
  theRunInformationTable.Clear();
  return( theStatus = tStatusSuccess );  
}
