// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TSOFTWARERUNINFORMATIONMODULE_HH
#define __TSOFTWARERUNINFORMATIONMODULE_HH

#include "TGlobals.hh"
#include "TSoftwareModule.hh"
#include "TRunInformationTable.hh"

class TDataSegment;
class TDataElement;

class TSoftwareRunInformationModule
  : public TSoftwareModule
{

  private:
    TRunInformationTable theRunInformationTable;

  public:
    TSoftwareRunInformationModule( Tint id = tIDunknown );
    TSoftwareRunInformationModule( const TRunInformationTable& table, Tint id = tIDunknown );
    TSoftwareRunInformationModule( const TSoftwareRunInformationModule& right );
    ~TSoftwareRunInformationModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();

  public:
    Tvoid FillData( const TDataSegment& segment );
    Tvoid FillData( const TDataElement& element );

  public:
    const TSoftwareRunInformationModule& operator=( const TSoftwareRunInformationModule& right );
    Tbool operator==( const TSoftwareRunInformationModule& right ) const;
    Tbool operator!=( const TSoftwareRunInformationModule& right ) const;

  public:
    TRunInformationTable& GetRunInformationTable();
    const TRunInformationTable& GetRunInformationTable() const;
    Tvoid SetRunInformationTable( const TRunInformationTable& table );

};

inline TRunInformationTable& TSoftwareRunInformationModule::GetRunInformationTable()
{
  return( theRunInformationTable );
}

inline const TRunInformationTable& TSoftwareRunInformationModule::GetRunInformationTable() const
{
  return( theRunInformationTable );
}

inline Tvoid TSoftwareRunInformationModule::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

#endif
