// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TVmeRpv130Module.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TVmeRpv130Module::TVmeRpv130Module( Tint baseaddress, Tint mapsize, Tint nch, Tint readmode )
  : TVmeModule( nch, baseaddress, mapsize, tA16D16 ),
    theReadoutMode( readmode ), theLevelStatus( 0x0000 )
{
  LevelUp();
}

TVmeRpv130Module::TVmeRpv130Module( const TVmeRpv130Module& right )
  : TVmeModule( right ), theReadoutMode( right.theReadoutMode ),
    theLevelStatus( right.theLevelStatus )
{;}

TVmeRpv130Module::~TVmeRpv130Module()
{;}

const TVmeRpv130Module& TVmeRpv130Module::operator=( const TVmeRpv130Module& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );
  theReadoutMode = right.theReadoutMode;
  theLevelStatus = right.theLevelStatus;
  return( *this );
}

Tbool TVmeRpv130Module::operator==( const TVmeRpv130Module& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
  ret &= ( theReadoutMode == right.theReadoutMode );
  ret &= ( theLevelStatus == right.theLevelStatus );
  return( ret );
}

Tbool TVmeRpv130Module::operator!=( const TVmeRpv130Module& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
  ret |= ( theReadoutMode != right.theReadoutMode );
  ret |= ( theLevelStatus != right.theLevelStatus );
  return( ret );
}

Tint TVmeRpv130Module::Clear()
{
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 0, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 1, 1 );

  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 0, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 1, 1 );
  return( theStatus = tStatusSuccess );
}

Tint TVmeRpv130Module::Update()
{
  return( Clear() );
}

Tint TVmeRpv130Module::Initialize()
{
  Clear();
  Disable();
  return( theStatus = tStatusSuccess );
}

Tvoid TVmeRpv130Module::FillData( const TDataSegment& segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    TUshort data = Read( i );
    TDataElement element( &data, tTypeShort, i );
    ( (TDataElementList*)(&segment) ) -> push_back( element );
  }
  return;
}

Tvoid TVmeRpv130Module::FillData( const TDataElement& element )
{
  Tint ch = element.GetID();
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::FillData: invalid ID" << Tendl;
    Tint tmp = -EFAULT;
    theStatus = -EFAULT;
    ( (TDataElement*)(&element) ) -> FillData( &tmp, tTypeInt );
  } else {
    TUshort data = Read( ch );
    ( (TDataElement*)(&element) ) -> FillData( &data, tTypeShort );
  }
  return;
}

Tvoid TVmeRpv130Module::Pulse()
{
  *( (TUshort*)( theModuleBaseAddress + PULSE ) ) = 0x000ff;
  return;
}

Tvoid TVmeRpv130Module::Pulse( int channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::Pulse: invalid ID" << Tendl;
    return;
  }

  TUshort tmp = 0x0001;
  tmp = tmp << channel;
  tmp &= 0x00ff;
  *( (TUshort*)( theModuleBaseAddress + PULSE ) ) = tmp;

  return;
}

Tvoid TVmeRpv130Module::LevelUp()
{
  *( (TUshort*)( theModuleBaseAddress + LEVEL ) ) = 0x00000;
  theLevelStatus = 0x0000;
  return;
}

Tvoid TVmeRpv130Module::LevelUp( int channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::LevelUp: invalid ID" << Tendl;
    return;
  }

  setBit( (TUshort*)(&theLevelStatus), channel, 0 );
  *( (TUshort*)( theModuleBaseAddress + LEVEL ) ) = theLevelStatus;

  return;
}

Tvoid TVmeRpv130Module::LevelDown()
{
  *( (TUshort*)( theModuleBaseAddress + LEVEL ) ) = 0x000ff;
  theLevelStatus = 0x00ff;
  return;
}

Tvoid TVmeRpv130Module::LevelDown( int channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::LevelDown: invalid ID" << Tendl;
    return;
  }

  setBit( (TUshort*)(&theLevelStatus), channel, 1 );
  *( (TUshort*)( theModuleBaseAddress + LEVEL ) ) = theLevelStatus;
  return;
}

Tvoid TVmeRpv130Module::Enable()
{
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 4, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 6, 1 );

  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 4, 1 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 6, 1 );
  return;
}

Tvoid TVmeRpv130Module::Disable()
{
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 4, 0 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR1 ), 6, 0 );

  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 4, 0 );
  setBit( (TUshort*)( theModuleBaseAddress + CSR2 ), 6, 0 );
  return;
}

TUshort TVmeRpv130Module::Read()
{
  TUshort data;
  switch ( theReadoutMode ) {
    case tReadoutWithLatch1:
      data = *( (TUshort*)( theModuleBaseAddress + LATCH1 ) );
    case tReadoutWithLatch2:
      data = *( (TUshort*)( theModuleBaseAddress + LATCH2 ) );
    case tReadoutWithRSFF:
      data = *( (TUshort*)( theModuleBaseAddress + RSFF ) );
    case tReadoutWithThrough:
      data = *( (TUshort*)( theModuleBaseAddress + THROUGH ) );
    default:
      data = *( (TUshort*)( theModuleBaseAddress + RSFF ) );
  }
  data &= 0x00ff;
  return( data );
}

TUshort TVmeRpv130Module::Read( Tint channel )
{
  TUshort data;
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeRpv130Module::Read: invalid ID" << Tendl;
    theStatus = -EFAULT;
    data = EFAULT;
  } else {
    data = Read();
    data = data >> channel;
    data = data & 0x01;
  }
  return( data );
}
