// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TRun.hh"
#include "TEventManager.hh"

TRun::TRun( Tint runid )
  : theRunID( runid ), theEventStack()
{
  theEventStack.clear();
}

TRun::TRun( const TEventStack& eventstack )
  : theRunID( 0 ), theEventStack( eventstack )
{;}

TRun::TRun( Tint runid, const TEventStack& eventstack )
  : theRunID( runid ), theEventStack( eventstack )
{;}

TRun::TRun( const TRun& right )
  : theRunID( right.theRunID ), theEventStack( right.theEventStack )
{;}

TRun::~TRun()
{;}

const TRun& TRun::operator=( const TRun& right )
{
  theRunID = right.theRunID;
  theEventStack = right.theEventStack;
  return( *this );
}

Tbool TRun::operator==( const TRun& right ) const
{
  if ( theRunID == right.theRunID && theEventStack == right.theEventStack )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TRun::operator!=( const TRun& right ) const
{
  if ( theRunID != right.theRunID || theEventStack != right.theEventStack )
    return( Ttrue );
  else
    return( Tfalse );
}

Tvoid TRun::Clear()
{
  theEventStack.clear();
  TEventManager::GetEventManager() -> SetNumberOfEvents( 0 );
  return;
}

Tstring TRun::GetRunIDofString() const
{
  static const Tsize_t maxlen = 256;
  Tchar* s = new Tchar[ maxlen ];
  snprintf( s, maxlen, "%d", theRunID );
  Tstring strrunid = s;
  delete [] s;
  return( strrunid );
}
