// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TRUNMANAGER_HH
#define __TRUNMANAGER_HH

#include "TGlobals.hh"
#include "TRun.hh"

class TUserInterface;
class TCommand;
class TRunAction;
class TEventAction;
class TEventManager;
class TSoftwareRunInformationModule;
class TAnalysisManager;

class TRunManager
{

  protected:
    static TRunManager* theRunManager;

  protected:
    Tstatus_t theStatus;
    TRun theRun;
    TRunAction* theRunAction;
    TEventManager* theEventManager;
    TUserInterface* theUserInterface;
    Tthread_t theThreadOfEventLoop;
    TSoftwareRunInformationModule* theRunInformationModule;
    TAnalysisManager* theAnalysisManager;

  public:
    TRunManager( TUserInterface* ui = 0 );
    virtual ~TRunManager();

  public:
    TUserInterface* GetUserInterface() const;
    const TRun& GetRun() const;
    TRun& GetRun();
    TRunAction* GetRunAction() const;
    TEventManager* GetEventManager() const;
    Tvoid SetUserInterface( TUserInterface* ui );
    Tint SetUserCommand( TCommand* command ) const;
    Tvoid SetRun( const TRun& run );
    Tvoid SetRunAction( TRunAction* action );
    Tvoid SetEventAction( TEventAction* action );
    Tvoid SetEventManager( TEventManager* manager );
    Tstatus_t GetStatus() const;
    Tvoid SetStatus( Tstatus_t status );
    Tthread_t GetThreadOfEventLoop() const;
    Tvoid SetThreadOfEventLoop( Tthread_t thread );
    TSoftwareRunInformationModule* GetRunInformationModule() const;
    TAnalysisManager* GetAnalysisManager() const;

  public:
    virtual Tvoid SessionStart();
    virtual Tvoid ShowStatus() const;
    virtual Tvoid PopupLogo() const;
    virtual Tvoid PopdownLogo() const;
    virtual Tvoid PrintAuthorInformation( Tostream& tos = Tcout ) const;
    virtual Tvoid ShutdownRun();
    virtual Tvoid StartRun();
    virtual Tvoid StartRun( Tint runid );
    virtual Tvoid StopRun();
    virtual Tvoid SuspendRun();
    virtual Tvoid ResumeRun();
    virtual Tvoid SetRunInformationModule( TSoftwareRunInformationModule* module );
    virtual Tvoid SetAnalysisManager( TAnalysisManager* manager );

  public:
    static TRunManager* GetRunManager();

  protected:
    static Tvoid* doEventLoop( Tvoid* arguments );
    static Tvoid* showLogo( Tvoid* arguments );

  public:
    virtual Tvoid GoEventLoop();
    virtual Tvoid WaitReturnFromEventLoop();

  protected:
    virtual TstringList getArguments( const Tstring& input ) const;
    virtual Tvoid installDefaultCommand();

};

inline TRunManager* TRunManager::GetRunManager()
{
  return( theRunManager );
}

inline TUserInterface* TRunManager::GetUserInterface() const
{
  return( theUserInterface );
}

inline Tvoid TRunManager::SetRun( const TRun& run )
{
  theRun = run;
  return;
}

inline const TRun& TRunManager::GetRun() const
{
  return( theRun );
}

inline TRun& TRunManager::GetRun()
{
  return( theRun );
}

inline TRunAction* TRunManager::GetRunAction() const
{
  return( theRunAction );
}

inline TEventManager* TRunManager::GetEventManager() const
{
  return( theEventManager );
}

inline Tstatus_t TRunManager::GetStatus() const
{
  return( theStatus );
}

inline Tvoid TRunManager::SetStatus( Tstatus_t status )
{
  theStatus = status;
  return;
}

inline Tthread_t TRunManager::GetThreadOfEventLoop() const
{
  return( theThreadOfEventLoop );
}

inline Tvoid TRunManager::SetThreadOfEventLoop( Tthread_t thread )
{
  theThreadOfEventLoop = thread;
  return;
}

inline TSoftwareRunInformationModule* TRunManager::GetRunInformationModule() const
{
  return( theRunInformationModule );
}

inline TAnalysisManager* TRunManager::GetAnalysisManager() const
{
  return( theAnalysisManager );
}

#endif
