// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TOutputObjectSharedMemory.hh"

TDataRecord create( Tint val );
static TOutputObjectSharedMemory* omemory = 0;
Tvoid catchsignal( Tint signal );

int main( int argc, char** argv, char** envv )
{
  enum { exCommand, exNumberOfEvents, exRate, exNumberOfArguments };
  if ( argc != exNumberOfArguments ) {
    Tcerr << "usage: " << argv[ exCommand ] << Tspace << "<nevent>";
    Tcerr << Tspace << "<rate>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ exNumberOfEvents ] );
  const Tint rate = atoi( argv[ exRate ] );
  omemory = new TOutputObjectSharedMemory();
  signal( SIGINT, catchsignal );
  signal( SIGSEGV, catchsignal );


  Tint datasize1 = 0;
  Tint datasize2 = 0;

  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = create( i );
    omemory -> WriteData( record );
    datasize1 += record.GetDataSize();
    datasize2 += omemory -> GetDataSize();
    Tcout << datasize1 << " byte data has been written down." << Tendl;
    sleep( rate );
  }

  Tcout << Tendl;
  Tcout << Ttab << datasize1 << Tslash << datasize2;
  Tcout << Tspace << "byte data has been written down" << Tendl;
  Tcout << Tendl;

  delete omemory;
  return( 0 );
}

TDataRecord create( Tint val )
{
  static const Tint recid = 0x1000;
  static const Tint secid = 0x1100;
  static const Tint seg1id = 0x1110;
  static const Tint seg2id = 0x1120;
  static const Tint seg3id = 0x1130;

  TDataRecord rec( recid );
  TDataSection sec( secid );
  TDataSegment seg1( seg1id );
  TDataSegment seg2( seg2id );
  TDataSegment seg3( seg3id );


  Ttime_t time_now;
  Tint pasttime = (Tint)time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tsize_t length = 64;
  Tchar* tmp = new Tchar[ length ];
  strftime( tmp, length,"%Y/%m/%d %H:%M:%S", tm_now );
  string tstr = tmp;
  delete [] tmp;
  const Tint nstrdata = 2;
  string strdata[ nstrdata ] = { 
    "ABCDEF ABCDEF ABCDEF ABCDEF END", 
    "abcefghijklmnopqrstuvwxyz abcefghijklmnopqrstuvwxyz end"
  };
  const Tint ndata = 1000;
  TUshort array[ ndata ];
  for ( Tint i = 0; i < ndata; i ++ )
    array[ i ] = (TUshort)( i + i );
  
  seg1.push_back( TDataElement( &pasttime, tTypeInt, 0 ) );
  seg1.push_back( TDataElement( &tstr, tTypeString, 1 ) );
  seg1.push_back( TDataElement( strdata, tTypeString, 2, nstrdata ) );
  seg1.push_back( TDataElement( array, tTypeWord, 3, ndata ) );
   
  for ( Tint i = 0; i < 8; i ++ ) {
    Tint data = i + i * i + 0x1234 * val;
    seg2.push_back( TDataElement( &data, tTypeInt, i + 100 ) );
  }


  for ( Tdouble i = 0.0; i < 16.0; i ++ ) {
    Tdouble data = sin( i * i * val + val );
    seg3.push_back( TDataElement( &data, tTypeDouble, (Tint)i ) );
  }

  sec.push_back( seg1 );
  sec.push_back( seg2 );
  sec.push_back( seg3 );
  rec.push_back( sec );

  return( rec );
}

Tvoid catchsignal( Tint signal )
{
  Tcout << "get signal " << signal << ", remove shm resource." << Tendl;
  delete omemory;
  exit( 0 );
}

