// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TDataRecord.hh"
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TSoftwareFlashAdcModule.hh"

int main( int argc, char** argv, char** envv )
{
  const Tint nevents = 10;

  TSoftwareFlashAdcModule fadc;
  TReadoutList list( 1000 );
  TReadoutSection sec( 1100 );
  TReadoutSegment seg( &fadc, 1100 );
  sec.push_back( seg );
  list.push_back( sec );


  for ( Tint eventid = 0; eventid < nevents; eventid ++ ) {
    TDataRecord record = list.ReadData();
    //Tcout << record << Tendl;
    fadc.Update();
  }
  

  return( 0 );
}
