// ============================================================================
//  $Id: BtDummyRunAction.cc,v 1.1 2002/12/07 13:14:40 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtDummyRunAction.hh"
#include "BtDummyModuleManager.hh"
#include "TOutputObjectFile.hh"
#include "TInputObjectFile.hh"
#include "TRun.hh"
#include "TDataRecord.hh"

BtDummyRunAction::BtDummyRunAction( BtDummyModuleManager* manager )
  : theOutputFile( 0 ), theInputFile( 0 ), theModuleManager( manager )
{;}

BtDummyRunAction::~BtDummyRunAction()
{;}

Tvoid BtDummyRunAction::BeginOfRunAction( TRun& aRun )
{
  Tint runid = aRun.GetRunID();

  Tstring filename = "run";
  Tstring runidstr = aRun.GetRunIDofString();
  if ( runid < 10 )
    filename += "00";
  else if ( runid < 100 )
    filename += "0";
  filename += runidstr + ".drec";

  theOutputFile = new TOutputObjectFile( filename );
  Tcout << "event data outputs into " << filename << Tendl;
  theInputFile = new TInputObjectFile( filename );


  TDataRecord record = 
    theModuleManager -> GetRunBeginReadoutList() -> ReadData();
  theOutputFile -> WriteData( record );

  return;
}

Tvoid BtDummyRunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theModuleManager -> GetRunEndReadoutList() -> ReadData();
  theOutputFile -> WriteData( record );

  delete theOutputFile;
  delete theInputFile;
  return;
}

Tvoid BtDummyRunAction::FinalOfRunAction( TRun& aRun )
{
  Tcout << "final action is called, but nothing to do." << Tendl;
  Tcout << "process is going to terminate." << Tendl;
  return;
}
