// ============================================================================
//  $Id: BtDummyRunAction.hh,v 1.1 2002/12/07 13:14:40 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __BTDUMMYRUNACTION_HH
#define __BTDUMMYRUNACTION_HH

#include "TGlobals.hh"
#include "TRunAction.hh"

class TRun;
class TOutputObjectFile;
class BtDummyModuleManager;
class TInputObjectFile;

class BtDummyRunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    TInputObjectFile* theInputFile;
    BtDummyModuleManager* theModuleManager;

  public:
    BtDummyRunAction( BtDummyModuleManager* manager );
    ~BtDummyRunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );
    Tvoid FinalOfRunAction( TRun& aRun );

    TOutputObjectFile* GetOutputFile() const;
    TInputObjectFile* GetInputFile() const;

};

inline TOutputObjectFile* BtDummyRunAction::GetOutputFile() const
{
  return( theOutputFile );
}

inline TInputObjectFile* BtDummyRunAction::GetInputFile() const
{
  return( theInputFile );
}

#endif
