// ============================================================================
//  $Id: DarkGraphExtractor.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "DarkGraphExtractor.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

DarkGraphExtractor::DarkGraphExtractor()
  : TAnalysisDataExtractor()
{;}

DarkGraphExtractor::~DarkGraphExtractor()
{;}

Tvoid DarkGraphExtractor::Extract( const TDataRecord& record )
{
  static const Tint findsegID = 1210;
  Tint ch = 0;
  TDataSection section;
  TDataSegment segment;
  TDataElement element;
  TUshort* databuf = 0;
  TdoubleList linebuf( 16, 0.0 );
  TMultipleData mdata;


  for ( Tsize_t i = 0; i < record.size(); i ++ ) {
    section = record[ i ];
    for ( Tsize_t j = 0; j < section.size(); j ++ ) {
      segment = section[ j ];
      if ( segment.GetID() == findsegID ) {
	element = segment[ ch ];
	databuf = (TUshort*)( element.GetData() );
	Tint nprvs = element.GetNumberOfPrimitives();	
	for ( Tint k = 0; k < nprvs; k ++ ) {
	  linebuf[ 0 ] = (Tdouble)( k );
	  linebuf[ 1 ] = (Tdouble)( databuf[ k ] );
	  mdata.push_back( linebuf );
	}
	theMultipleData = mdata;
      }
    }
  }

  return;
}
