// ============================================================================
//  $Id: DarkReadoutList.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __DARKREADOUTLIST_HH
#define __DARKREADOUTLIST_HH

#include "TGlobals.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TVmeMpx201aModule.hh"

class TReadoutList;
class TDataRecord;
class TSoftwareScalerModule;
class TSoftwareClockModule;
class TVmeMpx201aModule;

class DarkReadoutList
{

  private:
    TReadoutList theReadoutList;
    TSoftwareScalerModule* theScaler;
    TSoftwareClockModule* theClock;
    TVmeMpx201aModule* theFadc;

  public:
    DarkReadoutList();
    ~DarkReadoutList();

  public:
    TDataRecord ReadData();
    const TReadoutList& GetReadoutList() const;
    TSoftwareScalerModule* GetScaler() const;
    TSoftwareClockModule* GetClock() const;
    TVmeMpx201aModule* GetFadc() const;

};

inline TDataRecord DarkReadoutList::ReadData()
{
  return( theReadoutList.ReadData() );
}

inline const TReadoutList& DarkReadoutList::GetReadoutList() const
{
  return( theReadoutList );
}

inline TSoftwareScalerModule* DarkReadoutList::GetScaler() const
{
  return( theScaler );
}

inline TSoftwareClockModule* DarkReadoutList::GetClock() const
{
  return( theClock );
}

inline TVmeMpx201aModule* DarkReadoutList::GetFadc() const
{
  return( theFadc );
}

#endif
