// ============================================================================
//  $Id: TRootAnalyser.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TRootAnalyser.hh"
#include "TMatrixElement.hh"
#include "TAnalysisSuffix.hh"
#include "TAnalysisManager.hh"
#include "TRootCanvas.hh"
#include "TRoot1DHistogram.hh"
#include "TRoot2DHistogram.hh"
#include "TRootGraph.hh"
#include "TRootNtuple.hh"

TRootApplication* TRootAnalyser::theRootApplication = 0;

TRootAnalyser::TRootAnalyser()
  : TAnalyser( TRootIdentification ), theRootFile( 0 )
{
  theRootApplication = new TRootApplication( Tproject.c_str(), 0, 0 );
  gROOT -> Reset( 0 );

  Tstring filename = Tproject + ".root";
  Tstring title = Tproject + Tspace + Tversion;
  theRootFile = new TRootFile( filename.c_str(), "recreate", title.c_str() );
}

TRootAnalyser::~TRootAnalyser()
{
  if ( theRootFile ) {
    theRootFile -> Write();
    delete theRootFile;
  }
  //theRootApplication -> Terminate( 0 );
  delete theRootApplication;
  Tcout << "TRootAnalyser::~TRootAnalyser: RootApplication was deleted." << Tendl;
}

Tvoid TRootAnalyser::OpenCanvas( const Tstring& id, const Tstring& title, Tint width, Tint height )
{
  Tstring canvasid = id + TCanvasSuffix;
  new TRootCanvas( canvasid.c_str(), title.c_str(), width, height );
  return;
}

Tvoid TRootAnalyser::ClearCanvas( const Tstring& id )
{
  //Clear()
  return;
}

Tvoid TRootAnalyser::CloseCanvas( const Tstring& id )
{

  //delete
  return;
}

Tvoid TRootAnalyser::Create1DHistogram( const Tstring& id, const Tstring& title, Tint nbin, Tdouble min, Tdouble max )
{
  Tstring histoid = id + T1DHistogramSuffix;
  new TRoot1DHistogram( histoid.c_str(), title.c_str(), nbin, min, max );
  return;
}

Tvoid TRootAnalyser::Create2DHistogram( const Tstring& id, const Tstring& title, Tint xbin, Tdouble xmin, Tdouble xmax, Tint ybin, Tdouble ymin, Tdouble ymax )
{
  Tstring histoid = id + T2DHistogramSuffix;
  new TRoot2DHistogram( histoid.c_str(), title.c_str(), xbin, xmin, xmax, ybin, ymin, ymax );
  return;
}

Tvoid TRootAnalyser::CreateAppendGraph( const Tstring& id, const Tstring& title )
{
  Tstring graphid = id + TAppendGraphSuffix;
  TRootGraph* newgraph = new TRootGraph();
  newgraph -> SetName( graphid.c_str() );
  newgraph -> SetTitle( title.c_str() );
  return;
}

Tvoid TRootAnalyser::CreateSubstituteGraph( const Tstring& id, const Tstring& title )
{
  Tstring graphid = id + TSubstituteGraphSuffix;
  TRootGraph* newgraph = new TRootGraph();
  newgraph -> SetName( graphid.c_str() );
  newgraph -> SetTitle( title.c_str() );
  return;
}

Tvoid TRootAnalyser::Fill( const TMatrixElement& matrix )
{
  Tstring id = matrix.GetMatrixID();
  if ( IsExist( id ) ) {
    Tobject_t type = matrix.GetObjectType();
    switch ( type ) {
      case tObject1DHistogram:
	fill1DHistogram( matrix );
	break;
      case tObject2DHistogram:
	fill2DHistogram( matrix );
	break;
      case tObjectAppendGraph:
	fillAppendGraph( matrix );
	break;
      case tObjectSubstituteGraph:
	fillSubstituteGraph( matrix );
	break;
      case tObjectNtuple:
	fillNtuple( matrix );
	break;
      default:
	Tcerr << "TRootAnalyser::Fill: unknown or unsupported object." << Tendl;
	break;
    }
  }
  return;
}

Tvoid TRootAnalyser::Clear( const Tstring& id )
{
  //֥ȥפɤäƷ뤫
  //gROOT -> FindObject( id.c_str() ) -> Clear();
  return;
}

Tvoid TRootAnalyser::Remove( const Tstring& id )
{
  //gROOT -> FindObject( id.c_str() ) -> Delete();
  return;
}

Tvoid TRootAnalyser::Update( const Tstring& id )
{
  Tstring canvasid = id + TCanvasSuffix;
  TRootCanvas* canvas =
    (TRootCanvas*)(gROOT -> FindObject( canvasid.c_str() ));

  //if ( canvas && IsExistOnHeap( id ) ) {
  if ( canvas ) {
    canvas -> cd();
    gPad -> SetGrid();

    TAnalysisManager* manager = TAnalysisManager::GetAnalysisManager();
    TAnalysisStatusTable& table = manager -> GetStatusTable();
    Tobject_t type = table.GetObjectType( id );
    if ( IsExist( id ) ) {
      switch ( type ) {
	case tObject1DHistogram:
	  draw1DHistogram( id );
	  break;
	case tObject2DHistogram:
	  draw2DHistogram( id );
	  break;
	case tObjectAppendGraph:
	  drawAppendGraph( id );
	  break;
	case tObjectSubstituteGraph:
	  drawSubstituteGraph( id );
	  break;
	case tObjectNtuple:
	  drawNtuple( id );
	  break;
	default:
	  Tcerr << "TRootAnalyser::Update: unknown or unsupported object." << Tendl;
	  break;
      }
    }


    canvas -> Modified();
    canvas -> Update();
    gSystem -> ProcessEvents();
  }
  return;
}

Tvoid TRootAnalyser::fill1DHistogram( const TMatrixElement& matrix )
{
  Tstring histoid = matrix.GetMatrixID() + T1DHistogramSuffix;
  TRoot1DHistogram* histo =
    (TRoot1DHistogram*)(gROOT -> FindObject( histoid.c_str() ));
  for ( Tint i = 0; i < matrix.GetNumberOfEvents(); i ++ )
    histo -> Fill( matrix[ i ][ 0 ] );
  return;
}

Tvoid TRootAnalyser::fill2DHistogram( const TMatrixElement& matrix )
{
  Tstring histoid = matrix.GetMatrixID() + T2DHistogramSuffix;
  TRoot2DHistogram* histo =
    (TRoot2DHistogram*)(gROOT -> FindObject( histoid.c_str() ));
  for ( Tint i = 0; i < matrix.GetNumberOfEvents(); i ++ )
    histo -> Fill( matrix[ i ][ 0 ], matrix[ i ][ 1 ] );
  return;
}

Tvoid TRootAnalyser::fillSubstituteGraph( const TMatrixElement& matrix )
{
  Tstring graphid = matrix.GetMatrixID() + TSubstituteGraphSuffix;
  TRootGraph* graph =
    (TRootGraph*)(gROOT -> FindObject( graphid.c_str() ));
  for ( Tint i = 0; i < matrix.GetNumberOfEvents(); i ++ )
    graph -> SetPoint( i, matrix[ i ][ 0 ], matrix[ i ][ 1 ] );
  return;
}

Tvoid TRootAnalyser::fillAppendGraph( const TMatrixElement& matrix )
{
  Tstring graphid = matrix.GetMatrixID() + TSubstituteGraphSuffix;
  TRootGraph* graph =
    (TRootGraph*)(gROOT -> FindObject( graphid.c_str() ));
  Tint n = (Tint)( graph -> GetN() );
  for ( Tint i = n; i < matrix.GetNumberOfEvents(); i ++ )
    graph -> SetPoint( i, matrix[ i ][ 0 ], matrix[ i ][ 1 ] );
  return;
}

Tvoid TRootAnalyser::fillNtuple( const TMatrixElement& matrix )
{
  Tstring head = "TRootAnalyser::fillNtuple: ";
  Tcout << head << "under construction." << Tendl;
  return;
}

Tvoid TRootAnalyser::draw1DHistogram( const Tstring& id )
{
  Tstring histoid = id + T1DHistogramSuffix;
  TRoot1DHistogram* histo =
    (TRoot1DHistogram*)(gROOT -> FindObject( histoid.c_str() ));
  histo -> Draw();
  return;
}

Tvoid TRootAnalyser::draw2DHistogram( const Tstring& id )
{
  Tstring histoid = id + T2DHistogramSuffix;
  TRoot1DHistogram* histo =
    (TRoot1DHistogram*)(gROOT -> FindObject( histoid.c_str() ));
  histo -> Draw();
  return;
}

Tvoid TRootAnalyser::drawAppendGraph( const Tstring& id )
{
  Tstring graphid = id + TAppendGraphSuffix;
  TRootGraph* graph =
    (TRootGraph*)(gROOT -> FindObject( graphid.c_str() ));
  graph -> Draw( "ap" );
  return;
}

Tvoid TRootAnalyser::drawSubstituteGraph( const Tstring& id )
{
  Tstring graphid = id + TSubstituteGraphSuffix;
  TRootGraph* graph =
    (TRootGraph*)(gROOT -> FindObject( graphid.c_str() ));
  graph -> Draw( "ap" );
  return;
}

Tvoid TRootAnalyser::drawNtuple( const Tstring& id )
{
  Tstring head = "TRootAnalyser::drawNtuple: ";
  Tcout << head << "under construction." << Tendl;
  return;
}

Tbool TRootAnalyser::IsExist( const Tstring& id ) const
{
  TAnalysisManager* manager = TAnalysisManager::GetAnalysisManager() ;
  TAnalysisStatusTable& table = manager -> GetStatusTable();
  Tstring objectid = table.GetDrawableObjectID( id );
  if ( objectid.empty() )
    return( Tfalse );
  TObject* object = gROOT -> FindObject( objectid.c_str() );
  return( ( object ) ? Ttrue : Tfalse );
}

Tbool TRootAnalyser::IsOnHeap( const Tstring& id ) const
{
  TAnalysisManager* manager = TAnalysisManager::GetAnalysisManager() ;
  TAnalysisStatusTable& table = manager -> GetStatusTable();
  Tstring objectid = table.GetDrawableObjectID( id );
  if ( objectid.empty() )
    return( Tfalse );
  TObject* object = gROOT -> FindObject( objectid.c_str() );
  if ( object )
    return( (Tbool)( object -> IsOnHeap() ) );
  return( Tfalse );
}

Tvoid TRootAnalyser::SetRootFile( TRootFile* file )
{
  if ( theRootFile ) {
    theRootFile -> Write();
    delete theRootFile;
  }
  theRootFile = file;
  return;
}
