// ============================================================================
//  $Id: TDataRecord.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TDATARECORD_HH
#define __TDATARECORD_HH

#include "TGlobals.hh"
#include "TStreamableObject.hh"
#include "TDataSectionList.hh"

class TOutputObjectStream;

class TDataRecord
  : public TStreamableObject, public TDataSectionList
{

  public:
    TDataRecord( Tint id = tIDunknown );
    TDataRecord( const TDataRecord& right );
    ~TDataRecord();

  public:
    Tint GetDataSize();
    Tint WriteData( TOutputObjectStream* output );

  public:
    const TDataRecord& operator=( const TDataRecord& right );
    Tbool operator==( const TDataRecord& right ) const;
    Tbool operator!=( const TDataRecord& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TDataRecord& right );

  private:
    Tint writeToFile( TOutputObjectFile* ofile );
    Tint writeToSocket( TOutputObjectSocket* osocket );
    Tint writeToSharedMemory( TOutputObjectSharedMemory* omemory );

};

#endif
