// ============================================================================
//  $Id: TDataSection.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TDATASECTION_HH
#define __TDATASECTION_HH

#include "TGlobals.hh"
#include "TStreamableObject.hh"
#include "TDataSegmentList.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;

class TDataSection
  : public TStreamableObject, public TDataSegmentList
{

  public:
    TDataSection( Tint id = tIDunknown );
    TDataSection( const TDataSection& right );  
    ~TDataSection();

    Tint GetDataSize();
    Tint WriteData( TOutputObjectStream* objectfile );
    
  public:
    const TDataSection& operator=( const TDataSection& right );
    Tbool operator==( const TDataSection& right ) const;
    Tbool operator!=( const TDataSection& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TDataSection& right );

  private:
    Tint writeToFile( TOutputObjectFile* ofile );
    Tint writeToSocket( TOutputObjectSocket* osocket );
    Tint writeToSharedMemory( TOutputObjectSharedMemory* omemory );

};

#endif
