// ============================================================================
//  $Id: TEventManager.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TEventManager.hh"
#include "TRunManager.hh"
#include "TEventAction.hh"
#include "TDataRecord.hh"
#include "TEventAction.hh"
#include "TEventStack.hh"
#include "TReadoutList.hh"
#include "TRun.hh"

TEventManager* TEventManager::theEventManager = 0;

TEventManager::TEventManager( Tint stacksize )
  : theStatus( tStatusDead ), theStackSize( stacksize ), 
    theNumberOfEvents( 0 ), theEventAction( 0 ), theEvent()
{
  if ( theEventManager ) {
    Tcerr << "TEventManager::TEventManager: EventManager constructed twice." << Tendl;
    exit( -EFAULT );
  }
  theEventManager = this;
  theStatus = tStatusReady;
}

TEventManager::~TEventManager()
{
  Tstring head = "TEventManager::~TEventManager: ";
  if ( theEventAction ) {
    delete theEventAction;
    theEventAction = 0;
    Tcout << head << "EventAction was deleted." << Tendl;
  }
  theStatus = tStatusDead;
  Tcout << head << "EventManager was deleted." << Tendl;
  theEventManager = 0;
}

const TEvent& TEventManager::TakeEvent()
{
  theStatus = tStatusJustTakingEvent;

  theEvent.Clear();
  theEvent.SetEventID( theNumberOfEvents );
  if ( theEventAction ) {
    theEventAction -> BeginOfEventAction( theEvent );
    TReadoutList& list = (TReadoutList&)( theEventAction -> WaitEvent() );
    theEvent.SetDataRecord( list.ReadData() );
    theEventAction -> EndOfEventAction( theEvent );
  }
  theNumberOfEvents ++;

  theStatus = tStatusReady;
  return( theEvent );
}

const TRun& TEventManager::RecordEvent()
{
  theStatus = tStatusJustRecordingEvent;
  TRun& run = TRunManager::GetRunManager() -> GetRun();
  TEventStack& eventstack = run.GetEventStack();

  if ( theNumberOfEvents >= theStackSize )
    eventstack.erase( eventstack.begin() );
  eventstack.push_back( theEvent );

  theStatus = tStatusReady;
  return( run );
}

Tvoid TEventManager::ShowStatus() const
{
  Tcout << "Status: ";
  Tstring msg;
  switch ( theStatus ) {
    case tStatusReady:
      msg = "Ready";
      break;
    case tStatusJustTakingEvent:
      msg = "JustTakingEvent";
      break;
    case tStatusJustRecordingEvent:
      msg = "JustRecordingEvent";
      break;
    case tStatusDead:
      msg = "Dead";
      break;
    case tStatusUnknown:
    default:
      msg = "Unknown";
      break;
  }
  Tcout << msg << Tendl;
  Tcout << "Stack size: " << theStackSize << Tendl;
  Tcout << "Number of events: " << theNumberOfEvents << Tendl;
  Tcout << "Event ID: " << theEvent.GetEventID() << Tendl;
  return;
}

Tvoid TEventManager::SetStackSize( Tint stacksize )
{
  TRunManager* manager = TRunManager::GetRunManager();
  if ( manager -> GetStatus() == tStatusStandby ) {
    theStackSize = stacksize;
  } else {
    manager -> ShowStatus();
    Tstring head = "TEventManager::SetStackSize: ";
    Tcerr << head << "if you (re)set stacking size, you must stop a this run." << Tendl;
    Tcerr << head << "nothing to do, return." << Tendl;
  }
  return;
}

Tvoid TEventManager::SetEventAction( TEventAction* action )
{
  if ( theEventAction ) {
    Tstring head = "TEventManager::SetEventAction: ";
    delete theEventAction;
    Tcout << head << "EventAction was deleted." << Tendl;
    theEventAction = 0;
  }
  theEventAction = action;
  return;
}

Tvoid TEventManager::Clear()
{
  theNumberOfEvents = 0;
  theEvent.Clear();
  return;
}
