// ============================================================================
//  $Id: TCamacOutputRegisterModule.hh,v 1.2 2002/12/08 13:27:53 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TCAMACOUTPUTREGISTERMODULE_HH
#define __TCAMACOUTPUTREGISTERMODULE_HH

#include "TGlobals.hh"
#include "TCamacModule.hh"

class TDataSegment;
class TDataElement;

class TCamacOutputRegisterModule
  : public TCamacModule
{

  public:
    TCamacOutputRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tdata_t datalen = t16bitModule );
    TCamacOutputRegisterModule( const TCamacOutputRegisterModule& right );
    ~TCamacOutputRegisterModule();

  public:
    const TCamacOutputRegisterModule& operator=( const TCamacOutputRegisterModule& right );
    Tbool operator==( const TCamacOutputRegisterModule& right ) const;
    Tbool operator!=( const TCamacOutputRegisterModule& right ) const;

  public:
    Tvoid FillData( const TDataSegment& segment );
    Tvoid FillData( const TDataElement& element );

  public:
    Tint Pulse( Tint data );
    Tint Level( Tint data );

};

#endif
