// ============================================================================
//  $Id: TCamacSwitchRegisterModule.hh,v 1.1 2002/12/06 12:07:29 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TCAMACSWITCHREGISTERMODULE_HH
#define __TCAMACSWITCHREGISTERMODULE_HH

#include "TGlobals.hh"
#include "TCamacModule.hh"

enum Tread_t { tReadSwitch, tReadRegister };

class TDataSegment;
class TDataElement;

class TCamacSwitchRegisterModule
  : public TCamacModule
{

  private:
    Tread_t theReadTarget;

  public:
    TCamacSwitchRegisterModule( TCamacCrateController* cc7x00, Tint slot, Tread_t target = tReadSwitch, Tint nch = 1, Tdata_t datalen = t24bitModule );
    TCamacSwitchRegisterModule( const TCamacSwitchRegisterModule& right );
    ~TCamacSwitchRegisterModule();

  public:
    const TCamacSwitchRegisterModule& operator=( const TCamacSwitchRegisterModule& right );
    Tbool operator==( const TCamacSwitchRegisterModule& right ) const;
    Tbool operator!=( const TCamacSwitchRegisterModule& right ) const;

  public:
    Tvoid FillData( const TDataSegment& segment );
    Tvoid FillData( const TDataElement& element );
    Tint Read();

  public:
    Tread_t GetReadTarget() const;
    Tvoid SetReadTarget( Tread_t target );

};

inline Tread_t TCamacSwitchRegisterModule::GetReadTarget() const
{
  return( theReadTarget );
}

inline Tvoid TCamacSwitchRegisterModule::SetReadTarget( Tread_t target )
{
  theReadTarget = target;
  return;
}

#endif
