// ============================================================================
//  $Id: TVmeModule.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TVMEMODULE_HH
#define __TVMEMODULE_HH

#include "TGlobals.hh"
#include "TModule.hh"

class TVmeModule
  : public TModule
{

  protected:
    Tsize_t theMappedSize;
    TvmeTransfer_t theTransferMode;
    Tint theFileDescriptor;
    Tcaddr_t theModuleBaseAddress;

  public:
    TVmeModule( Tint nch, Tint baseaddress, Tint mapsize, TvmeTransfer_t mode );
    TVmeModule( const TVmeModule& right );

  protected:
    virtual ~TVmeModule();

  public:
    virtual const TVmeModule& operator=( const TVmeModule& right );
    virtual Tbool operator==( const TVmeModule& right ) const;
    virtual Tbool operator!=( const TVmeModule& right ) const;

  public:
    Tsize_t GetMappedSize() const;
    TvmeTransfer_t GetTransferMode() const;
    Tint GetFileDescriptor() const;
    Tcaddr_t GetModuleBaseAddress() const;

    Tvoid SetMappedSize( Tsize_t mapsize );
    Tvoid SetTransferMode( TvmeTransfer_t mode );
    Tvoid SetFileDescriptor( Tint fd );
    Tvoid SetModuleBaseAddress( Tcaddr_t address );

  protected:
    Tvoid showBit( TUshort data, const Tstring comment = "" ) const;
    Tvoid setBit( TUshort* ptr, Tint nbit, Tbit bit );
    Tbit getBit( TUshort* ptr, Tint nbit ) const;

};

inline Tsize_t TVmeModule::GetMappedSize() const
{
  return( theMappedSize );
}

inline TvmeTransfer_t TVmeModule::GetTransferMode() const
{
  return( theTransferMode );
}

inline Tint TVmeModule::GetFileDescriptor() const
{
  return( theFileDescriptor );
}

inline Tcaddr_t TVmeModule::GetModuleBaseAddress() const
{
  return( theModuleBaseAddress );
}

inline Tvoid TVmeModule::SetMappedSize( Tsize_t mapsize )
{
  theMappedSize = mapsize;
  return;
}

inline Tvoid TVmeModule::SetTransferMode( TvmeTransfer_t mode )
{
  theTransferMode = mode;
  return;
}

inline Tvoid TVmeModule::SetFileDescriptor( Tint fd )
{
  theFileDescriptor = fd;
  return;
}

inline Tvoid TVmeModule::SetModuleBaseAddress( Tcaddr_t address )
{
  theModuleBaseAddress = address;
  return;
}

#endif
