// ============================================================================
//  $Id: TInputObjectFile.cc,v 1.4 2002/12/07 23:07:23 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TInputObjectFile.hh"
#include "TStreamableObject.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TObjectFilter.hh"

TInputObjectFile::TInputObjectFile( const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TInputObjectStream( tFileStream )
{;}

TInputObjectFile::TInputObjectFile( TObjectFilter* filter, const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TInputObjectStream( filter, tFileStream )
{;}

TInputObjectFile::~TInputObjectFile()
{;}

Tint TInputObjectFile::ReadData( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;

  if ( HasFilter() )
    return( theObjectFilter -> Analyse( object, this ) );
  

  static Tobject_t objecttype = object.GetObjectType();

  switch ( objecttype ) {
    case tObjectDataRecord:
      *( (TDataRecord*)(&object) ) = getDataRecord();
      break;
    case tObjectDataSection:
      *( (TDataSection*)(&object) ) = getDataSection();
      break;
    case tObjectDataSegment:
      *( (TDataSegment*)(&object) ) = getDataSegment();
      break;
    case tObjectDataElement:
      *( (TDataElement*)(&object) ) = getDataElement();
      break;
    default:
      break;
  }

  theTotalDataSize += theDataSize; 

  return( theDataSize );
}

TDataRecord TInputObjectFile::getDataRecord()
{
  Tint id;
  Tint entries;
  readProperties( id, entries );

  TDataRecord record( id );
  if ( theDataSize == 0 )
    return( record );

  for ( Tint i = 0; i < entries; i ++ )
    record.push_back( getDataSection() );

  return( record );
}

TDataSection TInputObjectFile::getDataSection()
{
  Tint id;
  Tint entries;
  readProperties( id, entries );

  TDataSection section( id );
  if ( theDataSize == 0 )
    return( section );

  for ( Tint i = 0; i < entries; i ++ )
    section.push_back( getDataSegment() );

  return( section );
}

TDataSegment TInputObjectFile::getDataSegment()
{
  Tint id;
  Tint entries;
  readProperties( id, entries );

  TDataSegment segment( id );
  if ( theDataSize == 0 )
    return( segment );

  for ( Tint i = 0; i < entries; i ++ )
    segment.push_back( getDataElement() );

  return( segment );
}

TDataElement TInputObjectFile::getDataElement()
{
  static const Tsize_t nmemb = 1;
  Tint id;
  Telement_t type;
  Tint nprvs;
  TDataElement element;

  // read id
  if ( ( fread( &id, Tsizeof( id ), nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::getDataElement" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return( element );
  } else {
    theDataSize += Tsizeof( id );
    element.SetID( id );
  }

  // read element type
  if ( ( fread( &type, Tsizeof( type ), nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::getDataElement" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return( element );
  } else {
    theDataSize += Tsizeof( type );
    element.SetElementType( type );
  }

  // read number of primitives
  if ( ( fread( &nprvs, Tsizeof( nprvs ), nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::getDataElement" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return( element );
  } else {
    theDataSize += Tsizeof( nprvs );
    element.SetNumberOfPrimitives( nprvs );
  }

  Tstring* strbuf = 0;
  Tchar* cc = 0;
  Tint* ii = 0;
  TUint* ui = 0;
  Tdouble* dd = 0;
  TUshort* us = 0;
  Tshort* ss = 0;
  Tfloat* ff = 0;
  Tlong* ll = 0;
  TUlong* ul = 0;

  switch ( type ) {

    case tTypeInt:
      ii = new Tint[ nprvs ];
      if ( fread( ii, Tsizeof( Tint ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( ii, nprvs );
	theDataSize += (Tint)( Tsizeof( Tint ) * nprvs );
      }
      delete [] ii;
      break;


    case tTypeUnsignedInt:
      ui = new TUint[ nprvs ];
      if ( fread( ui, Tsizeof( TUint ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( ui, nprvs );
	theDataSize += (Tint)( Tsizeof( TUint ) * nprvs );
      }
      delete [] ui;
      break;


    case tTypeWord:
    case tTypeUnsignedShort:
      us = new TUshort[ nprvs ];
      if ( fread( us, Tsizeof( TUshort ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( us, nprvs );
	theDataSize += (Tint)( Tsizeof( TUshort ) * nprvs );
      }
      delete [] us;
      break;

    case tTypeDouble:
      dd = new Tdouble[ nprvs ];

      if ( fread( dd, Tsizeof( Tdouble ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( dd, nprvs );
	theDataSize += (Tint)( Tsizeof( Tdouble ) * nprvs );
      }
      delete [] dd;
      break;

    case tTypeFloat:
      ff = new Tfloat[ nprvs ];

      if ( fread( ff, Tsizeof( Tfloat ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( ff, nprvs );
	theDataSize += (Tint)( Tsizeof( Tfloat ) * nprvs );
      }
      delete [] ff;
      break;


    case tTypeShort:
      ss = new Tshort[ nprvs ];
      if ( fread( ss, Tsizeof( Tshort ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( ss, nprvs );
	theDataSize += (Tint)( Tsizeof( Tshort ) * nprvs );
      }
      delete [] us;
      break;

    case tTypeLong:
      ll = new Tlong[ nprvs ];
      if ( fread( ll, Tsizeof( Tlong ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( ll, nprvs );
	theDataSize += (Tint)( Tsizeof( Tlong ) * nprvs );
      }
      delete [] ll;
      break;

    case tTypeUnsignedLong:
      ul = new TUlong[ nprvs ];
      if ( fread( ul, Tsizeof( TUlong ) * nprvs, nmemb, theFileStream ) != nmemb ) {
	//perror( "TInputObjectFile::getDataElement" );
	SetOffset( 0, SEEK_END );
	theDataSize = 0;
	return( element );
      } else {
	element.FillData( ul, nprvs );
	theDataSize += (Tint)( Tsizeof( TUlong ) * nprvs );
      }
      delete [] ul;
      break;

    case tTypeString:
      strbuf = new Tstring[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	Tint nchar;
	if ( fread( &nchar, Tsizeof( Tint ), nmemb, theFileStream ) != (Tsize_t)nmemb ) {
	  SetOffset( 0, SEEK_END );
	  theDataSize = 0;
	  return( element );
	} else {
	  theDataSize += (Tint)( Tsizeof( Tint ) * nmemb );
	  cc = new Tchar[ nchar ];
	}
	if ( fread( cc, Tsizeof( Tchar ) * nchar, nmemb, theFileStream ) != (Tsize_t)nmemb ) {
	  //perror( "TInputObjectFile::getDataElement" );
	  SetOffset( 0, SEEK_END );
	  theDataSize = 0;
	  return( element );
	} else {
	  theDataSize += (Tint)( Tsizeof( Tchar ) * nchar );
	}
	strbuf[ i ] = cc;
	delete [] cc;
      }
      element.FillData( strbuf, nprvs );
      delete [] strbuf;
      break;

    case tTypeUnknown:
    case tTypeObject:
    default:
      break;
  }

  return( element );
}

Tvoid TInputObjectFile::readProperties( Tint& id, Tint& entries )
{
  static const Tsize_t nmemb = 1;
  static const Tint datasize = Tsizeof( Tint );

  // ɤߤ˼ԤȤν⤦礤ޤ˹ͤʤ
  // SEEK ƸˤɤäꡢΥ쥳ɤФƤߤȤ
  // ȡꥪץȤεǽɬ

  if ( ( fread( &id, datasize, nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::readProperties" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return;
  } else {
    theDataSize += datasize;
  }

  if ( ( fread( &entries, datasize, nmemb, theFileStream ) != nmemb ) ) {
    //perror( "TInputObjectFile::readProperties" );
    SetOffset( 0, SEEK_END );
    theDataSize = 0;
    return;
  } else {
    theDataSize += datasize;
  }

  return;
}
