// ============================================================================
//  $Id: TInputObjectFile.hh,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __TINPUTOBJECTFILE_HH
#define __TINPUTOBJECTFILE_HH

#include "TGlobals.hh"
#include "TObjectFile.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;
class TObjectFilter;

class TInputObjectFile
  : public TObjectFile, public TInputObjectStream
{

  public:
    TInputObjectFile( const Tstring& filename, const Tstring& mode = "r" );
    TInputObjectFile( TObjectFilter* filter, const Tstring& filename, const Tstring& mode = "r" );
    ~TInputObjectFile();

  public:
    Tint ReadData( TStreamableObject& object );
  
  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& id, Tint& entries );

};

#endif
