// ============================================================================
//  $Id: TInputObjectSharedMemory.cc,v 1.5 2002/12/07 23:07:23 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TInputObjectSharedMemory.hh"
#include "TStreamableObject.hh"
#include "TObjectFilter.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TInputObjectSharedMemory::TInputObjectSharedMemory( Tint memsize, Tint maxevt )
  : TObjectSharedMemory( memsize, maxevt ), 
    TInputObjectStream( tSharedMemoryStream ),
    theReadSuccessFlag( Ttrue )
{;}

TInputObjectSharedMemory::TInputObjectSharedMemory( TObjectFilter* filter, Tint memsize, Tint maxevt )
  : TObjectSharedMemory( memsize, maxevt ), 
    TInputObjectStream( filter, tSharedMemoryStream ),
    theReadSuccessFlag( Ttrue )
{;}

TInputObjectSharedMemory::~TInputObjectSharedMemory()
{;}

Tint TInputObjectSharedMemory::ReadData( TStreamableObject& object )
{
  while ( IsReadable() == Tfalse ) {
    usleep( 100 );
  }

  theLastDataSize = theDataSize;
  theDataSize = 0;

  if ( theCurrentPositionOfMemorySpace == theMaxEvent - 1 ) {
    // return to top
    theAddress = theBaseAddress;
    theCurrentPositionOfMemorySpace = 0;
  }
    
  if ( HasFilter() )
    return( theObjectFilter -> Analyse( object, this ) );

  static Tobject_t objecttype = object.GetObjectType();

  Tvoid* membuf = theAddress;

  switch ( objecttype ) {
    case tObjectDataRecord:
      *( (TDataRecord*)(&object) ) = getDataRecord();
      break;
    case tObjectDataSection:
      *( (TDataSection*)(&object) ) = getDataSection();
      break;
    case tObjectDataSegment:
      *( (TDataSegment*)(&object) ) = getDataSegment();
      break;
    case tObjectDataElement:
      *( (TDataElement*)(&object) ) = getDataElement();
      break;
    default:
      break;
  }

  if ( !( theReadSuccessFlag ) ) {
    theAddress = membuf;
    theDataSize = 0;
  }

  if ( theDataSize > 0 )
    theCurrentPositionOfMemorySpace ++;

  theTotalDataSize += theDataSize;
  return( theDataSize );
}

TDataRecord TInputObjectSharedMemory::getDataRecord()
{
  Tint id;
  Tint entries;
  readProperties( id, entries );

  TDataRecord record( id );
  if ( theDataSize == 0 )
    return( record );

  for ( Tint i = 0; i < entries; i ++ )
    record.push_back( getDataSection() );

  return( record );
}

TDataSection TInputObjectSharedMemory::getDataSection()
{
  Tint id;
  Tint entries;
  readProperties( id, entries );

  TDataSection section( id );
  if ( theDataSize == 0 )
    return( section );

  for ( Tint i = 0; i < entries; i ++ )
    section.push_back( getDataSegment() );

  return( section );
}

TDataSegment TInputObjectSharedMemory::getDataSegment()
{
  Tint id;
  Tint entries;
  readProperties( id, entries );

  TDataSegment segment( id );
  if ( theDataSize == 0 )
    return( segment );

  for ( Tint i = 0; i < entries; i ++ )
    segment.push_back( getDataElement() );

  return( segment );
}

TDataElement TInputObjectSharedMemory::getDataElement()
{
  TDataElement element;

  // βϥ쥬ȤǤϤʤ
  theReadSuccessFlag = Ttrue;

  // read object ID
  Tint id;
  id = *( (Tint*)theAddress );
  theDataSize += Tsizeof( id );
  ( (Tint*)theAddress ) ++;
  element.SetID( id );

  // read element type
  Telement_t type;
  type = *( (Telement_t*)theAddress );
  theDataSize += Tsizeof( type );
  ( (Telement_t*)theAddress ) ++;
  element.SetElementType( type );

  // read number of primitives
  Tint nprvs;
  nprvs = *( (Tint*)theAddress );
  theDataSize += Tsizeof( nprvs );
  ( (Tint*)theAddress ) ++;
  element.SetNumberOfPrimitives( nprvs );

  if ( nprvs == 0 ) {
    theReadSuccessFlag = Tfalse;
    return( element );
  }

  Tstring* strbuf = 0;
  Tchar* cc = 0;
  Tint* ii = 0;
  TUint* ui = 0;
  Tdouble* dd = 0;
  TUshort* us = 0;
  Tshort* ss = 0;
  Tfloat* ff = 0;
  Tlong* ll = 0;
  TUlong* ul = 0;

  // read primitive data
  switch ( type ) {

    case tTypeInt:
      ii = new Tint[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	// read int data
	ii[ i ] = *( (Tint*)theAddress );
	theDataSize += Tsizeof( Tint );
	( (Tint*)theAddress ) ++;
      }
      element.FillData( ii, nprvs );
      delete [] ii;
      break;


    case tTypeUnsignedInt:
      ui = new TUint[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	// read int data
	ui[ i ] = *( (TUint*)theAddress );
	theDataSize += Tsizeof( TUint );
	( (TUint*)theAddress ) ++;
      }
      element.FillData( ui, nprvs );
      delete [] ui;
      break;


    case tTypeWord:
    case tTypeUnsignedShort:
      us = new TUshort[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	// read ushort data
	us[ i ] = *( (TUshort*)theAddress );
	theDataSize += Tsizeof( TUshort );
	( (TUshort*)theAddress ) ++;
      }
      element.FillData( us, nprvs );
      delete [] us;
      break;

    case tTypeDouble:
      dd = new Tdouble[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	// read double data
	dd[ i ] = *( (Tdouble*)theAddress );
	theDataSize += Tsizeof( Tdouble );
	( (Tdouble*)theAddress ) ++;
      }
      element.FillData( dd, nprvs );
      delete [] dd;
      break;

    case tTypeFloat:
      ff = new Tfloat[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	// read double data
	ff[ i ] = *( (Tfloat*)theAddress );
	theDataSize += Tsizeof( Tfloat );
	( (Tfloat*)theAddress ) ++;
      }
      element.FillData( ff, nprvs );
      delete [] ff;
      break;

    case tTypeShort:
      ss = new Tshort[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	// read short data
	ss[ i ] = *( (Tshort*)theAddress );
	theDataSize += Tsizeof( Tshort );
	( (Tshort*)theAddress ) ++;
      }
      element.FillData( ss, nprvs );
      delete [] ss;
      break;

    case tTypeLong:
      ll = new Tlong[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	// read long data
	ll[ i ] = *( (Tlong*)theAddress );
	theDataSize += Tsizeof( Tlong );
	( (Tlong*)theAddress ) ++;
      }
      element.FillData( ll, nprvs );
      delete [] ll;
      break;

    case tTypeUnsignedLong:
      ul = new TUlong[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {
	// read long data
	ul[ i ] = *( (TUlong*)theAddress );
	theDataSize += Tsizeof( TUlong );
	( (TUlong*)theAddress ) ++;
      }
      element.FillData( ul, nprvs );
      delete [] ul;
      break;

    case tTypeString:
      strbuf = new Tstring[ nprvs ];
      for ( Tint i = 0; i < nprvs; i ++ ) {

	// read number of characters
	Tint nchar;
	nchar = *( (Tint*)theAddress );
	theDataSize += Tsizeof( nchar );
	( (Tint*)theAddress ) ++;

	// read string
	cc = new Tchar[ nchar ];
	for ( Tint j = 0; j < nchar; j ++ ) {
	  cc[ j ] = *( (Tchar*)theAddress );
	  theDataSize += Tsizeof( Tchar );
	  ( (Tchar*)theAddress ) ++;
	}

	strbuf[ i ] = cc;
	delete [] cc;
      }
      element.FillData( strbuf, nprvs );
      delete [] strbuf;
      break;

    case tTypeUnknown:
    case tTypeObject:
    default:
      break;
  }


  return( element );
}

Tvoid TInputObjectSharedMemory::readProperties( Tint& id, Tint& entries )
{
  static const Tsize_t idsize = Tsizeof( Tint );
  static const Tsize_t entrysize = Tsizeof( Tint );

  // βϥ쥬ȤǤϤʤ
  theReadSuccessFlag = Ttrue;

  // read object ID
  id = *( (Tint*)theAddress );
  theDataSize += idsize;
  ( (Tint*)theAddress ) ++;

  // read number of entries
  entries = *( (Tint*)theAddress );
  theDataSize += entrysize;
  ( (Tint*)theAddress ) ++;


  if ( id == 0 && entries == 0 )
    theReadSuccessFlag = Tfalse;

  return;
}
