// ============================================================================
//  $Id: TOutputObjectFile.cc,v 1.2 2002/12/07 23:07:24 iwai Exp $
//  $Name:  $
// ============================================================================
#include "TOutputObjectFile.hh"
#include "TObjectFilter.hh"

TOutputObjectFile::TOutputObjectFile( const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( tFileStream )
{;}

TOutputObjectFile::TOutputObjectFile( TObjectFilter* filter, const Tstring& filename, const Tstring& mode )
  : TObjectFile( filename, mode ), TOutputObjectStream( filter, tFileStream )
{;}

TOutputObjectFile::~TOutputObjectFile()
{;}

Tint TOutputObjectFile::WriteData( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;
  if ( HasFilter() )
    theDataSize = theObjectFilter -> Filter( object, this );
  else
    theDataSize = object.WriteData( this );
  theTotalDataSize += theDataSize;
  return( theDataSize );
}
